/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.sensor;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.sensor.StaticParserSensorType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class StaticParserSensorTypeItemProvider
	extends SensorBaseTypeItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DIRECTORY = AcadEditorPlugin.getPlugin().getString("STR_STATICPS_DIR");
	public static final String FILE_NAME = AcadEditorPlugin.getPlugin().getString("STR_STATICPS_FILE");
	public static final String CLASS_NAME = AcadEditorPlugin.getPlugin().getString("STR_STATICPS_PARSER");	
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticParserSensorTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDirectoryPropertyDescriptor(object);
			addFileNamePropertyDescriptor(object);
			addParserClassNamePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Directory feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDirectoryPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_STATICPS_DIR"),
				 getString("_UI_PropertyDescriptor_description", "STR_STATICPS_DIR", "_UI_StaticParserSensorType_type"),
				 SensorPackage.eINSTANCE.getStaticParserSensorType_Directory(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the File Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addFileNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_STATICPS_FILE"),
				 getString("_UI_PropertyDescriptor_description", "STR_STATICPS_FILE", "_UI_StaticParserSensorType_type"),
				 SensorPackage.eINSTANCE.getStaticParserSensorType_FileName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Parser Class Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addParserClassNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_STATICPS_PARSER"),
				 getString("_UI_PropertyDescriptor_description", "STR_STATICPS_PARSER", "_UI_StaticParserSensorType_type"),
				 SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}


	/**
	 * This returns StaticParserSensorType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_STREAM);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((StaticParserSensorType)object).getFileName();
		return label == null || label.length() == 0 ?
			getString("_UI_StaticParserSensorType_type") :
			getString("_UI_StaticParserSensorType_type") + " " + label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(StaticParserSensorType.class)) {
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__DIRECTORY:
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__FILE_NAME:
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE__PARSER_CLASS_NAME: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
