/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.*;

/**
 * @author popescu
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogSelectionDialog extends SelectionDialog {

   protected Object selection;
   
	/**
	 * @param parentShell
	 */
	public LogSelectionDialog(Shell parentShell) {
		super(parentShell);
		
		setTitle(AcadEditorPlugin.getPlugin().getString("STR_SEL_DLG_TITLE"));
	}

	protected Control createDialogArea(Composite parent) {
	  // create composite 
	  Composite dialogArea = (Composite)super.createDialogArea(parent);
	  GridData data = GridUtil.createFill();
	  data.widthHint = 300;
	  data.heightHint = 400;
	  dialogArea.setLayoutData(data);
	  dialogArea.setLayout(new GridLayout());
	  
	  Tree tree = new Tree(dialogArea, SWT.SINGLE|SWT.BORDER);
	  tree.setLayoutData(GridUtil.createFill());
	  final TreeViewer selectionViewer = new TreeViewer(tree);
	  
	  selectionViewer.setContentProvider(new WorkbenchContentProvider());
	  selectionViewer.setLabelProvider(new WorkbenchLabelProvider());
	  
	  selectionViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
	  
		selectionViewer.addSelectionChangedListener(
			new ISelectionChangedListener() {
				public void selectionChanged(SelectionChangedEvent event) {
					IStructuredSelection selection = (IStructuredSelection)event.getSelection();
					setSelection(selection.getFirstElement()); // allow null
				}
			});
		selectionViewer.addDoubleClickListener(
			new IDoubleClickListener() {
				public void doubleClick(DoubleClickEvent event) {
					ISelection selection = event.getSelection();
					if (selection instanceof IStructuredSelection) {
						Object item = ((IStructuredSelection)selection).getFirstElement();
						if (selectionViewer.getExpandedState(item))
						selectionViewer.collapseToLevel(item, 1);
						else
						selectionViewer.expandToLevel(item, 1);
					}
				}
			});
	  
	  return dialogArea;
	}

/**
 * @return
 */
public Object getSelection() {
	return selection;
}

/**
 * @param object
 */
public void setSelection(Object object) {
	selection = object;
}

}
