/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class SensorSection extends Composite
								implements IDetails, ModifyListener
										   , INotifyChangedListener
{
	protected Label uniqueIDText;		
	protected Text descriptionText;		
	
	protected Text maxText;
	
    protected boolean isDisplaying;
    protected SensorConfigType currentSelection;
    protected SensorConfigTypeItemProvider itemProvider;
    protected SensorItemProviderAdapterFactory itemFactory;
	
	
	public SensorSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new SensorItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
						
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SENSOR_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.NULL);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SENSOR_ID"), SWT.NONE);	
		uniqueIDText = factory.createLabel(this, "", SWT.NULL);
		uniqueIDText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SENSOR_MAXB"), SWT.NONE);	
		maxText = factory.createText(this, "", SWT.NULL);
		maxText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		maxText.addModifyListener(this);
		descriptionText.addModifyListener(this);
		
		itemProvider = (SensorConfigTypeItemProvider)itemFactory.createSensorConfigTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
        
		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer());
        
		if(currentSelection == object)
		  return;
        
		if(maxText.isFocusControl()
		   || uniqueIDText.isFocusControl()
		   || descriptionText.isFocusControl())
		   
		  return;
        
		currentSelection = (SensorConfigType)object;
		isDisplaying = true;
		
		maxText.setText(currentSelection.getMaximumBlocking()==null?"":currentSelection.getMaximumBlocking());
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		uniqueIDText.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (SensorConfigType)currentSelection;
		
		this.currentSelection.setUniqueID(uniqueIDText.getText());
		this.currentSelection.setDescription(descriptionText.getText());
		this.currentSelection.setMaximumBlocking(maxText.getText());
				
		return false;

	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == maxText)
		{
			String text = maxText.getText();
			if(!text.equals(currentSelection.getMaximumBlocking()))
			{
				if(text.length() == 0 && currentSelection.getMaximumBlocking() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						SensorConfigTypeItemProvider.MAX_BLOCKING);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}		  
		else if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						SensorConfigTypeItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

}
