/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;
/**
 * ISensor defines the basic Sensor implementation requriements.
 **/
public interface ISensor extends IProcessUnit
{
	/**
	 * Method getNextLine.
	 * interface method for the ISensor functionality to be included into 
	 * the pipeline of the filters as a first filter
	 * @return String 
	 */
	public Object[] getNext();
	public Object[] testGetNext();
	public Object[] flush();
	/**
	  * Method setType. Set the sensor type.
	 */
	public void setType(String newType);
	/**
	  * Method getType. returns the sensor type.
	  * @return String
	 */
	public String getType();
}
