/*
 * Created on Nov 11, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.logging.adapter.extractors;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.MalformedPatternException;
import java.util.Hashtable;
/**
 * @author sluiman
 *
 */
public class RegularExpressionExtractor extends SimpleExtractor {
	private Perl5Compiler compiler = new Perl5Compiler();
	private Perl5Matcher matcher = new Perl5Matcher();
	private Hashtable patterns = new Hashtable();
	private PatternMatcherInput input = new PatternMatcherInput("");
	protected StringPosition search(String pattern, int startPosition) {
		boolean found = false;
		String temp = null;
		int foundPosition = -1;
		int foundEndPosition = -1;
		input.setInput(
			searchString,
			startPosition,
			searchString.length() - startPosition);
		matcher.setMultiline(true);
		found = matcher.contains(input, getPattern(pattern));
		temp = null;
		if (found) {
			temp = input.match();
			MatchResult result = matcher.getMatch();
			foundPosition = input.getMatchBeginOffset();
			foundEndPosition = input.getMatchEndOffset();
		}
		if (foundPosition > -1)
		{
		
//			if (temp.length() < 1)
//				return new StringPosition(foundPosition, foundPosition);
//			else
				return new StringPosition(
					foundPosition,
					foundEndPosition);
		}
		else
			return null;
	}
	Pattern getPattern(String input) {
		Pattern result = null;
		result = (Pattern) patterns.get(input);
		if (result == null) {
			try {
				result = compiler.compile(input);
			} catch (MalformedPatternException e) {
			}
			patterns.put(input, result);
		}
		return result;
	}
}
