package org.eclipse.hyades.logging.adapter.internal.util;


import org.eclipse.hyades.logging.adapter.AdapterPlugin;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
public class ComponentLoaderUtil
{
	/**
	 * Instatiate an object and guarantee its class.
	 * @param className The name of the class to instantiate.
	 * @param impls The name of the class it subclases.
	 **/
	public static Object instantiate(String className, String impls)
	{	
		try
		{
			Class c = Class.forName(impls);
			try
			{
				Class o = Class.forName(className);
				Object res = o.newInstance();
				if (c.isInstance(res))
					return res;
				else
					throw new IllegalArgumentException(className + " is not an instance of " + impls);
			}
			catch (Throwable e) {
				/* We may be running inside of eclipse.  If this is the case then we will 
				 * look at our extensions to see if anyone has provided this class in 
				 * another plugin.
				 */
				 
				 try {
				 	return AdapterPlugin.getComponent(className);
				 }
				 catch(Throwable eprime) {
				 	throw new ClassNotFoundException(eprime.getMessage()) ;
				 }
			}
		}
		catch (ClassNotFoundException e)
		{
			System.err.println("Error loading class " + impls + ": was not found.");
		}
		return null;
	}
}