/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.outputters;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author smith
 *
 * This outputter writes CBE's to a logging agent
 * 
 */
public class CBELogOutputter extends ProcessUnit implements IOutputter {
	private LoggingAgent cbelogger = null;
	
	private static String defaultAgentName = "GenericAdapterCBELogger";
	
	private String agentName = null;
	
	private long waitTime = 0;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(java.lang.Object[])
	 */
	public Object[] processEventItems(Object[] msgs) {
		if (msgs == null)
			return null;
		return processCBEs((ICommonBaseEvent[]) msgs);

	}

	/**
	 * Process the CBE events passed in.
	 * @param events CBE events to process
	 * @return ICommonBaseEvent[]
	 */
	private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] events)
	{
		// If the agent is not being monitored then wait for it to be so
		
		if (events.length > 0 && !cbelogger.isLogging() && getWaitTime() > 0) {
			log(Messages.getString("HyadesGA_CBE_Logging_Agent_Waiting_Info",getUniqueID(),getAgentName()),AdapterSensor.INFO_LEVEL);
			while ( !cbelogger.waitUntilLogging(getWaitTime())) {
				log(Messages.getString("HyadesGA_CBE_Logging_Agent_Waiting_Info",getUniqueID(),getAgentName()),AdapterSensor.INFO_LEVEL);
			} 
			
/*          This does not work - waitUntilLogging is not returning true after user attaches to 
			agent but it should. 
 
			if (!cbelogger.waitUntilLogging(60000)) {
				if (!cbelogger.isLogging()) {
				return events;
				}
			}
*/			
		}
		
		for (int i = 0; i < events.length; i++)
		{
			if (events[i] != null) {
								
				try {
					// Write CBE to logging agent
					cbelogger.write(events[i].toString());
				} catch (Exception ioe) {					
					log(Messages.getString("HyadesGA_CBE_Logging_Agent_Write_Error",getUniqueID(),getAgentName()),AdapterSensor.FATAL_LEVEL);
				}
			}
		}
		return events;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#testProcessEventItems(java.lang.Object[])
	 */
	public Object[] testProcessEventItems(Object[] msgs)
		throws AdapterInvalidConfig {
			if(!(msgs instanceof ICommonBaseEvent[])) {
				throw new AdapterInvalidConfig("This outputter will only accept arrays of ICommonBaseEvent");
			}
			return testProcessCBEs((ICommonBaseEvent[]) msgs);
		}
		
	private ICommonBaseEvent[] testProcessCBEs(ICommonBaseEvent[] events)
		{
			return events;
		}


	/**
	 * update the configuration based on the configuration Element
	 */
	public void update() throws AdapterInvalidConfig {
		
		// first get the basic configuration set
		super.update();
		
		// Get configuration
		Element outputterInstance = null;
		Element element = getConfiguration();
		// This outputter is configured with a sub element of the config
		NodeList outputters = element.getChildNodes();
		for (int i = 0; i < outputters.getLength(); i++)
			if (outputters.item(i).getNodeType() == Node.ELEMENT_NODE)
				outputterInstance = (Element) outputters.item(i);
		// Get attributes		
		if (outputterInstance.hasAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"))) {
			String wtime = outputterInstance.getAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"));
			if (wtime != null && !wtime.equals("")) {
				setWaitTime(Long.valueOf(wtime).longValue());
			}
		}									
		if (outputterInstance.hasAttribute(Messages.getString("HyadesGAagentNameAttributeName")))
			setAgentName(outputterInstance.getAttribute(Messages.getString("HyadesGAagentNameAttributeName")));

		// Create the logging agent
		if (cbelogger == null) {
			String logAgentName;
			if (getAgentName() == null) {
				logAgentName = defaultAgentName;
			}
			else {
				logAgentName = getAgentName();
			}
			cbelogger = new LoggingAgent(logAgentName);
		}

	}

	/**
	 * Sets the agent name
	 * @param aName The agent name to set
	 */

	public void setAgentName(String aName) {
		agentName = aName;
	}

	/**
	 * Gets the agent name
	 * @return String
	 */

	public String getAgentName() {
		return agentName;
	}

	/**
	 * Sets the wait time.
	 * @param wTime The wait time to set
	 */

	public void setWaitTime(long wTime) {
		waitTime = wTime;
	}

	/**
	 * @return
	 */
	/**
	 * Gets the wait time.
	 * @return long
	 */

	public long getWaitTime() {
		return waitTime;
	}

	public void stop() {
		cbelogger.deregister();
	}
}
