/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.action;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class CollapseAllAction 
extends Action implements IDisposable
{
	private TreeViewer treeViewer;
	
	/**
	 * Constructor for CollapseAllAction
	 */
	public CollapseAllAction(TreeViewer treeViewer)
	{
		super();
		this.treeViewer = treeViewer;
		
		WorkbenchHelp.setHelp(this, HyadesUIPlugin.getID() + ContextIds.ACT_COLLAPSE_ALL);		
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		treeViewer = null;
	}
	
	/**
	 * Returns whether the tree viewer has at least one expanded elements.
	 * @return boolean
	 */
	public boolean isAvailable()
	{
		if(treeViewer == null)
			return false;
			
		TreeItem[] items = treeViewer.getTree().getItems();
		for (int i = 0, maxi = items.length; i < maxi; i++)
		{
			if(items[i].getExpanded())
				return true;
		}
		
		return false;
	}
	
	/**
	 * Sets the text, tool tip and image to the resource's default.
	 * @return this action
	 */
	public CollapseAllAction useDefaultDecorators()
	{
		setText(ResourceNavigatorMessages.getString("CollapseAllAction.title"));
		setToolTipText(ResourceNavigatorMessages.getString("CollapseAllAction.toolTip")); 
		setImageDescriptor(getImageDescriptor("elcl16/collapseall.gif")); 
		setHoverImageDescriptor(getImageDescriptor("clcl16/collapseall.gif"));
		
		return this; 		
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		if((treeViewer == null) || treeViewer.getControl().isDisposed())
			dispose();
		else
			treeViewer.collapseAll();
	}
	
	/**
	 * Returns the image descriptor from the eclipse UI plugin with the given relative 
	 * path.
	 * @return ImageDescriptor;
	 */
	protected ImageDescriptor getImageDescriptor(String relativePath)
	{
		String iconPath = "icons/full/";
		try
		{
			AbstractUIPlugin plugin = (AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath + relativePath);
			return ImageDescriptor.createFromURL(url);
		}
		catch(MalformedURLException e)
		{
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}	
}
