/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.util.zip.ZipFile;

/**
 * @author marcelop
 * @since 0.0.1
 */
public interface IProjectAdjuster
{
	public ZipFile adjust(CreationWizardPage[] pages, CreationWizardPage currentPage, ZipFile zipFile);
	public void finished(CreationWizardPage currentPage, ZipFile zipFile);
	
	public File adjust(CreationWizardPage[] pages, CreationWizardPage currentPage, File file);
	public void finished(CreationWizardPage page, File file);
	
	public void beforeWorspaceRefresh(CreationWizardPage[] pages);
	public void afterWorspaceRefresh(CreationWizardPage[] pages);
}
