/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.views.SDViewer;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.*;


public class OpenLogViewAction
	extends Action
	implements IWorkbenchWindowActionDelegate, IViewActionDelegate
{

	public OpenLogViewAction() {
		super("");

	}

	public OpenLogViewAction(String label) {
		super(label);
	}

	public OpenLogViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public void run() {
		//System.out.println("OpenSDViewAction.run");
		IWorkbenchWindow window =
		SDLogcPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			EObject object = (EObject)HyadesUtil.getMofObject();
			SDViewer view = (SDViewer)persp.showView("org.eclipse.hyades.sd.ui.internal.views.SDViewer");
			
            int graphType=0;
			if (view != null){
				String menuItemName=getText();
				if(menuItemName.equals(SDLogcPlugin.getString("STR_MENU_LOR")))
			        graphType=Graph.LOGoverRECORD;
				else if(menuItemName.equals(SDLogcPlugin.getString("STR_MENU_LOT")))
					graphType=Graph.THREADoverRECORD;			        
					
				view.addLoadViewPage(object,graphType,true);
		   }
		} catch (Exception e) {
			String msg = SDLogcPlugin.getString("STR_LOAD_SD_ERR_");

			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",err);

			e.printStackTrace();
		}

	}

	public void dispose() {
	}
	
	public void init(IWorkbenchWindow window) {
	}

	  
	//---- IWorkbenchWindowActionDelegate ------------------------------------------------

	public void run(IAction action) {
		run();
	}

	public void selectionChanged(IAction action, ISelection selection)
    {
	}
	
	public void init(IViewPart view)
	{
	}
	
}

