/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCGCRootType;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;

/**
 * 
 * @author slavescu
 */
public final class XMLgcRootLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final String TYPE = "type";

    //~ Instance fields ----------------------------------------------------------------------------

    protected TRCGCRootType fType;

	private TRCHeapDump heapDump;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.TYPE_int:
            fType = TRCGCRootType.get(value);

            break;
        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        if (!loadToModel) {
            if (objIdRef >= 0) {
                theProcess = getProcess();
                if(theProcess.getHeapDumps().size()>0)
                {
                	heapDump = (TRCHeapDump)theProcess.getHeapDumps().get(theProcess.getHeapDumps().size()-1);
                	dispatchProcessMode(ProcessSteps.ALL);
                }
            }
        }
    }

    public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();

        super.initialize(context, name);
        fType = TRCGCRootType.UNKNOWN_LITERAL;
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(step);

        theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));

        if (theObject == null) {
        	return;
        }
        
        TRCHeapRoot heapRoot = TraceFactory.eINSTANCE.createTRCHeapRoot();
        heapRoot.setType(fType);
        heapRoot.setHeapDump(heapDump);
        heapRoot.setObject(theObject);
    }

 }
