package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Hashtable;

/**
 * ApacheAccessLogParser is a concrete subclass of the {@link AbstractAccessLogParser},
 * and it provides the parser functions particular to Apache Web Server access logs.
 */
public class ApacheAccessLogParser extends AbstractAccessLogParser {

	/**
	 * This function is called to provide user-specified information to the parser.
	 * Currently in this subclass, this method handles the Apache Web Server version
	 * information.  The superclass, {@link Parser}, handles the path and name of the 
	 * log file to be parsed.  
	 *
	 * @param table  Hashtable containing keys and values of user-specified information  
	 * @exception LogParserException thrown by the superclass
	 */
	public void setConfiguration(Hashtable table) throws LogParserException {

		super.setConfiguration(table);

		productVersion = ((String) (table.get(ParserConstants.APACHE_VERSION_KEY)));
	
		sourceID = ParserConstants.APACHE_HTTP_SERVER;

		if (productVersion != null)
			sourceID = sourceID.concat(" ").concat(productVersion);
	}

	/**
	 * Retrieves the name of this parser; the name indicates the type of log
	 * parsed.
	 *
	 * @return the name of this parser 
	 */
	public String getName() {
		return ParserConstants.APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_NAME;
	}

	/**
	 * Retrieves the version of this parser.
	 *
	 * @return the version of this parser 
	 */
	public String getVersion() {
		return ParserConstants.APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_VERSION;
	}

}
