/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.util.internal;

import java.util.Iterator;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodProperties;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.internal.util.OpenJavaSource;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class OpenSource
{
/**
 * openSource is takes an object of either a JMessage, JObject or JClass and attempts
 * to locate the source for the definition of that object within the workbench.  If the
 * source is found, the text editor within the Java Perspective is opened and the source 
 * is highlighted.
 * @param Object selection - the object for which you want the source definition.
 */	
public static void openSource(Object selection) {	
	
	String pattern = null;
	int javaType;
	
	if(selection == null)
	{
		MessageDialog.openInformation(
		UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
		UIPlugin.getResourceString("STR_TRACE_MSG"),
		UIPlugin.getResourceString("STR_EMPTY_SOURCE_NOT_FOUND_INFO_"));		
		
		return;
	}
			
	if(selection instanceof TRCMethodInvocation)
	{
		selection = ((TRCMethodInvocation)selection).getMethod();
	}
	
   	if (selection instanceof TRCMethod) {
		TRCMethod trcMethod = (TRCMethod) selection;
		
		if((trcMethod.getModifier() & TRCMethodProperties.JAVA_CONSTRUCTOR) !=0 )
		{
			javaType = IJavaSearchConstants.CONSTRUCTOR;
			// For constructors we only require the parameter signature appended to the class name
			TRCClass clas = trcMethod.getDefiningClass();
			
			String packName = clas.getPackage().getName();
			if(packName.equals(""))
				pattern = (new StringBuffer())
				                     .append(clas.getName()).append(trcMethod.getSignature()).toString();			
			else			
				pattern = (new StringBuffer()).append(clas.getPackage().getName()).append(".")
				                     .append(clas.getName()).append(trcMethod.getSignature()).toString();
		}
		
		else
		 {
			TRCClass clas = trcMethod.getDefiningClass();
			javaType = IJavaSearchConstants.METHOD;
			
			String packName = clas.getPackage().getName();
			if(packName.equals(""))
				pattern = (new StringBuffer())
				                     .append(clas.getName()).append(".")
				                     .append(trcMethod.getName()).append(trcMethod.getSignature()).toString();			
			else			
				pattern = (new StringBuffer()).append(clas.getPackage().getName()).append(".")
				                     .append(clas.getName()).append(".")
				                     .append(trcMethod.getName()).append(trcMethod.getSignature()).toString();
			
		}
	} 
	else {
		javaType = IJavaSearchConstants.TYPE;
		if (selection instanceof TRCObjectReference)
		{
			TRCObjectReference obj = (TRCObjectReference)selection;
			if (TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION)==TraceConstants.OBJ_REF_REFERANDS)
			{
				selection = obj.getOwner();
			}
			else
			{
				selection = obj.getTarget();
			}
		}
		if (selection instanceof TRCObject) {
			
			TRCObject obj = (TRCObject)selection;
//			selection = obj.getClassClassType();
//			if(selection == null) selection = obj.getIsA();			
			if(obj.getIsA()==obj.getProcess().getClassClass())
				selection = findClassType(obj);
			else
				selection = obj.getIsA();
		} 
		
		if (selection instanceof TRCClass) {
			
			TRCClass clas = (TRCClass) selection;
			
			String packName = clas.getPackage().getName();
			if(packName.equals(""))
				pattern = clas.getName();
			else			
				pattern = (new StringBuffer()).append(clas.getPackage().getName()).append(".")
				                     .append(clas.getName()).toString();
		} 
		else {
			// Unhandled Object Type.  This error will be handled in the subsequent call to openSource.
		}
	}
	
	// Now call the core utility function to actually locate and open the source for the object.
	if(!OpenJavaSource.openSource(pattern, javaType, null, true))
	{
		MessageDialog.openInformation(
		UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
			UIPlugin.getResourceString("STR_TRACE_MSG"),
			HyadesUtil.change(UIPlugin.getResourceString("STR_SOURCE_NOT_FOUND_INFO_"), "%1", pattern));
		
	}
}

private static Object findClassType(TRCObject obj) {
	for (Iterator iter1 = obj.getProcess().getPackages().iterator(); iter1.hasNext();) {
		TRCPackage aPackage = (TRCPackage) iter1.next();
		for (Iterator iter2 = aPackage.getClasses().iterator(); iter2.hasNext();) {
			TRCClass aClass = (TRCClass) iter2.next();
			for (Iterator iter3 = aClass.getClassObjects().iterator();iter3.hasNext();) {
				TRCObject aObject = (TRCObject) iter3.next();
				if(aObject == obj)
					return aClass;
			}
		}
	}
	return obj.getIsA();
}
	

}