/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.ui.preferences;

import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility.RecorderHarnessUIException;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * preference page for setting up the HttpProxyRecorder
 * @author Ernest Jessee
 */

public class HttpRecorderPreferencePage	extends PreferencePage implements IWorkbenchPreferencePage 
{
	
	private Text hostName;
	private Text hostPort;
	private Button autoStartAppBtn;
	private Combo recordedAppAdapterCombo;
	
	private Combo testGeneratorsCombo;
	private Text proxyPort;
	private Button autoStartTestGenBtn;
	class SelectionChangeHandler implements SelectionListener
	{
		public void widgetDefaultSelected(SelectionEvent e)
		{

		}

		public void widgetSelected(SelectionEvent e)
		{		
			updateControls();
		}

	}

	public HttpRecorderPreferencePage()
	{
		setPreferenceStore(HttpRecorderPlugin.getDefault().getPreferenceStore());
		initializeDefaults();
	}

	private void initializeDefaults() 
	{
		
	}
	
	
	
	public void init(IWorkbench workbench) {
	}
	
	
	protected Control createContents(Composite grandParent)
	{
		
		Composite parent = null;
			
		try
		{
			setTitle(HttpRecorderPlugin.getResourceString("HTTP_PROXY_RECORD_OPTIONS_TITLE")); //$NON-NLS-1$
			
			parent = new Composite(grandParent,SWT.NULL);
			
			WorkbenchHelp.setHelp(parent,"org.eclipse.hyades.execution.recorder.http.HttpRecorderPreferencePage"); //$NON-NLS-1$
			
			parent.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL));
								
			RecorderUIUtility.assignGridLayout(parent,2, false);
			
			createApplicationOptionsGroup(parent);
						
			createTestGenOptionsGroup(parent);
			
			createRecorderProxyGroup(parent);
			
					
			
		}
		catch (RecorderHarnessUIException e)
		{
			e.printStackTrace();
		}
		
		setControl(grandParent);
		return grandParent;
	
	}

	
	private void createRecorderProxyGroup(Composite parent)
			throws RecorderHarnessUIException
	{
		Label proxyPortLabel = RecorderUIUtility.createLabel(parent,HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.PROXY_RECORDER_LOCAL_PORT_LABEL"),null); //$NON-NLS-1$
		RecorderUIUtility.layoutControlInGrid(proxyPortLabel, 1, GridData.HORIZONTAL_ALIGN_END);
	
		proxyPort = RecorderUIUtility.createEditControl(parent, HttpRecorderPlugin.getPreference(HttpRecorderPlugin.PROXY_PORT),null);
		RecorderUIUtility.layoutControlInGrid(proxyPort,1,GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL);
		
		
	
	}

	private void createApplicationOptionsGroup(Composite parent) throws RecorderHarnessUIException
	{
		Label recorderAppLabel = RecorderUIUtility.createLabel(parent,HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.APPLICATION_ADAPTER_SELECTOR_LABEL"),null); //$NON-NLS-1$
		RecorderUIUtility.layoutControlInGrid(recorderAppLabel,1,GridData.HORIZONTAL_ALIGN_END);
		
		recordedAppAdapterCombo = new Combo(parent,SWT.DROP_DOWN|SWT.READ_ONLY);
		RecorderAppAdapterFactory adapterFactory = RecorderAppAdapterFactory.getInstance();
		
		String[] adapters = adapterFactory.getAdapterIDs();
		
		for(int i=0; i<adapters.length; i++)
		{
			String adapterName = adapterFactory.getAdapterName(adapters[i]);
			recordedAppAdapterCombo.add(adapterName);
			if(adapters[i].compareToIgnoreCase(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDER_APP_ADAPTER))==0)
			{
				recordedAppAdapterCombo.select(i);				
			}			
		}	
		
		recordedAppAdapterCombo.add(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")); //$NON-NLS-1$
		
		if(recordedAppAdapterCombo.getSelectionIndex()==-1)
			recordedAppAdapterCombo.select(recordedAppAdapterCombo.indexOf(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"))); //$NON-NLS-1$
			
		RecorderUIUtility.layoutControlInGrid(recordedAppAdapterCombo,1,GridData.GRAB_HORIZONTAL|GridData.HORIZONTAL_ALIGN_FILL);
		
		RecorderUIUtility.layoutControlInGrid(recordedAppAdapterCombo,1,GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL);
			
		
	}
	
	private void createTestGenOptionsGroup(Composite parent) throws RecorderHarnessUIException
	{
		
	
		Label testGeneratorLabel = RecorderUIUtility.createLabel(parent,HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.TEST_GENERATOR_LABEL"),null); //$NON-NLS-1$
		RecorderUIUtility.layoutControlInGrid(testGeneratorLabel,1,GridData.HORIZONTAL_ALIGN_END);
	
		testGeneratorsCombo = new Combo(parent,SWT.DROP_DOWN|SWT.READ_ONLY);
		TestGeneratorFactory factory = TestGeneratorFactory.getInstance();
		
	
				
		for(int i=0; i<factory.getGeneratorIDs().length; i++)
		{
			String generatorName = factory.getGeneratorName(factory.getGeneratorIDs()[i]);
			testGeneratorsCombo.add(generatorName);
			if(factory.getGeneratorIDs()[i].compareToIgnoreCase(HttpRecorderPlugin.getPreference(HttpRecorderPlugin.TEST_GENERATOR))==0)
			{
				testGeneratorsCombo.select(i);				
			}
		
		}
		
		testGeneratorsCombo.add(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));	 //$NON-NLS-1$
		
		if(testGeneratorsCombo.getSelectionIndex()==-1)
			testGeneratorsCombo.select(testGeneratorsCombo.indexOf(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"))); //$NON-NLS-1$
			
		RecorderUIUtility.layoutControlInGrid(testGeneratorsCombo,1,GridData.GRAB_HORIZONTAL|GridData.HORIZONTAL_ALIGN_FILL);
	
		RecorderUIUtility.layoutControlInGrid(testGeneratorsCombo,1,GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL);
		
		
	}
	
	public void updateControls()
	{		
	

	}

	

	//TODO defaults
	protected void performDefaults()
	{
		super.performDefaults();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performApply()
	 */
	protected void performApply()
	{
		IPreferenceStore store = getPreferenceStore();
		
		String adapterID = RecorderAppAdapterFactory.getInstance().getAdapterIDByIndex(recordedAppAdapterCombo.getSelectionIndex());
		if(adapterID!=null)
			store.setValue(HttpRecorderPlugin.RECORDER_APP_ADAPTER,adapterID);
		else	
			store.setValue(HttpRecorderPlugin.RECORDER_APP_ADAPTER,"-1"); //$NON-NLS-1$
		
		
		String generatorID = TestGeneratorFactory.getInstance().getGeneratorIDByIndex(testGeneratorsCombo.getSelectionIndex());
		if(generatorID!=null)
			store.setValue(HttpRecorderPlugin.TEST_GENERATOR,generatorID);
		else	
			store.setValue(HttpRecorderPlugin.TEST_GENERATOR,"-1"); //$NON-NLS-1$
		
		store.setValue(HttpRecorderPlugin.PROXY_PORT,proxyPort.getText());		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	public boolean performOk()
	{
		 performApply();
		 return true;
	}

}