/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.statistical.ui.widgets.spinner.internal.DateSpinner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class ExportTimeDialog extends Dialog {

boolean DEBUG = true;

Shell shell;

Composite main_panel;

Text avg_panel;
DateSpinner start_panel;
DateSpinner finish_panel;

Composite button_panel;
Button cancel_button;
Button ok_button;

long avg_period_ms;
long start_t;
long finish_t;

public static final int OK = 0;
public static final int CANCEL = 1;

boolean ok = false;

//long thedate = 0;

	public ExportTimeDialog(Shell shell, long avg_period_ms, long start_t, long finish_t) {
		super(shell);
		this.avg_period_ms = avg_period_ms;
		this.start_t = start_t;
		this.finish_t = finish_t;
		setText(EditorPlugin.getString("EXPORT_TITLE"));
	}
	public int open () {
		Shell parent = getParent();
		shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(getText());
		shell.setLayout(new FillLayout());
		shell.setSize(500,220);
		
		initGraphics();
		
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
		}
		
		if (ok) {
			return OK;
		} else {
			return CANCEL;	
		}
	}

	public long getAveragePeriodMS() {
		return avg_period_ms;
	}
	public long getStartTime() {
		return start_t;
	}
	public long getMaxTime() {
		return finish_t;
	}

	private void initGraphics() {
		main_panel = new Composite(shell,0);
		
		GridLayout glayout = new GridLayout();
		glayout.numColumns = 2;
		main_panel.setLayout(glayout);

		new Label(main_panel,0).setText(EditorPlugin.getString("EXPORT_AVERAGE_OVER"));

		avg_panel = new Text(main_panel,SWT.BORDER);
		avg_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		new Label(main_panel,0).setText(EditorPlugin.getString("EXPORT_START_AT"));

		start_panel = new DateSpinner(main_panel,0,false);
		start_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		new Label(main_panel,0).setText(EditorPlugin.getString("EXPORT_FINISH_AT"));

		finish_panel = new DateSpinner(main_panel,0,false);
		finish_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		button_panel = new Composite(main_panel,0);
		button_panel.setLayoutData(GData.getGridData(false,false,-1,-1,2,1,GridData.CENTER,GridData.END));

		glayout = new GridLayout();
		glayout.numColumns = 2;
		button_panel.setLayout(glayout);

		ok_button = new Button(button_panel,0);
		ok_button.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		ok_button.setText(EditorPlugin.getString("OK"));

		cancel_button = new Button(button_panel,0);
		cancel_button.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		cancel_button.setText(EditorPlugin.getString("CANCEL"));
	        
        ButtonListener blist = new ButtonListener();
        
        ok_button.addSelectionListener(blist);
        cancel_button.addSelectionListener(blist);
    
		avg_panel.setText(""+(avg_period_ms/1000));
		start_panel.setDate(start_t);
		finish_panel.setDate(finish_t);
	}
	
	
	class ButtonListener implements SelectionListener {
        
        public void widgetDefaultSelected(SelectionEvent e) {
        	widgetSelected(e);
        }
        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == cancel_button) {
                ok = false;
                shell.dispose();
                
            } else if (e.getSource() == ok_button) {
                ok = true;

				try {
					avg_period_ms = 1000l*Long.parseLong(avg_panel.getText());
					start_t = start_panel.getDate();
					finish_t = finish_panel.getDate();
	
	                shell.dispose();
				} catch (NumberFormatException x) {
					MessageBox mbox = new MessageBox(shell,SWT.OK|SWT.ICON_ERROR);
					mbox.setText(EditorPlugin.getString("EXPORT_INVALID_PERIOD"));
					mbox.setMessage(avg_panel.getText()+" "+EditorPlugin.getString("EXPORT_INVALID_PERIOD_MSG"));
				} 
                
            }//end if
        }//end method
        
    }//end class

}