/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution.core.impl;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IProcessConsole;

/**
 * 
 */
public class JavaTaskExecutorImpl extends ExecutionComponentImpl implements IExecutor {

	private IExecutableObject executable;
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#launch()
	 */
	public void launch() throws ExecutionComponentStateException {
		checkConfiguration();
		((IJavaTaskExecutableObject)executable).start();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#kill()
	 */
	public void kill() throws ExecutionComponentStateException {
		checkConfiguration();
		((JavaTaskExecutableObject)executable).stop();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#setExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject)
	 */
	public void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException {
		executable=theExecutableObject;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getExecutableObject()
	 */
	public IExecutableObject getExecutableObject()
	{
		return executable;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getProcessConsole()
	 */
	public IProcessConsole getProcessConsole()
		throws ExecutionComponentStateException {
		return null;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getCompatibleExecutableObject()
	 */
	public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
		throw new UnsupportedOperationException("This operation is implemented in the stub");
	}

	/**
	 * Insure this executor has been been appropriately configured for the
	 * requested operation.
	 * 
	 * @throws ExecutionComponentStateException
	 */	
	protected void checkConfiguration() throws ExecutionComponentStateException {
		if ( executable == null )
			throw new ExecutionComponentStateException(
			IExecutionComponent.NOT_CONFIGURED,
			"This executor has not been configured with an executable object");
		if ( !(executable instanceof IJavaTaskExecutableObject ) )
			throw new ExecutionComponentStateException(
			IExecutionComponent.NOT_CONFIGURED,
			"The executable object is not an IJavaTaskExecutableObject");
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#supportsControlEvent(java.lang.String)
	 */
	public boolean supportsControlEvent(String controlEvent) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#performControlEvent(java.lang.String)
	 */
	public String performControlEvent(String controlEvent) {
		return "";
	}

}
