/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.probekit.internal;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.probekit.internal.ProbekitFactory
 * @generated
 */
public interface ProbekitPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "probekit";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	// String eNS_URI = "file:/E:/tova/wsad/5.1/workspace/ProbekitSchemas/probekit.xsd";
	String eNS_URI = "platform:/resource/org.eclipse.hyades.models.probekit/src/model/probekit.xsd";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "probekit";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ProbekitPackage eINSTANCE = org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.CodeImpl <em>Code</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.CodeImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getCode()
	 * @generated
	 */
	int CODE = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE__VALUE = 0;

	/**
	 * The number of structural features of the the '<em>Code</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.ControlKeyImpl <em>Control Key</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ControlKeyImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getControlKey()
	 * @generated
	 */
	int CONTROL_KEY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_KEY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_KEY__VALUE = 1;

	/**
	 * The number of structural features of the the '<em>Control Key</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_KEY_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.ControlNameImpl <em>Control Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ControlNameImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getControlName()
	 * @generated
	 */
	int CONTROL_NAME = 2;

	/**
	 * The feature id for the '<em><b>Lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_NAME__LANG = 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_NAME__TEXT = 1;

	/**
	 * The number of structural features of the the '<em>Control Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_NAME_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.DataImpl <em>Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.DataImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getData()
	 * @generated
	 */
	int DATA = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__TYPE = 1;

	/**
	 * The number of structural features of the the '<em>Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.DescriptionImpl <em>Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.DescriptionImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getDescription()
	 * @generated
	 */
	int DESCRIPTION = 4;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION__LANG = 1;

	/**
	 * The number of structural features of the the '<em>Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.FragmentImpl <em>Fragment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.FragmentImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getFragment()
	 * @generated
	 */
	int FRAGMENT = 5;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Data</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT__DATA = 1;

	/**
	 * The feature id for the '<em><b>Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT__CODE = 2;

	/**
	 * The number of structural features of the the '<em>Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.FragmentAtClassScopeImpl <em>Fragment At Class Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.FragmentAtClassScopeImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getFragmentAtClassScope()
	 * @generated
	 */
	int FRAGMENT_AT_CLASS_SCOPE = 6;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_AT_CLASS_SCOPE__VALUE = 0;

	/**
	 * The number of structural features of the the '<em>Fragment At Class Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FRAGMENT_AT_CLASS_SCOPE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.ImportImpl <em>Import</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ImportImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getImport()
	 * @generated
	 */
	int IMPORT = 7;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT__TEXT = 0;

	/**
	 * The number of structural features of the the '<em>Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.InvocationObjectImpl <em>Invocation Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.InvocationObjectImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getInvocationObject()
	 * @generated
	 */
	int INVOCATION_OBJECT = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_OBJECT__NAME = 0;

	/**
	 * The number of structural features of the the '<em>Invocation Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_OBJECT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.NameImpl <em>Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.NameImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getName_()
	 * @generated
	 */
	int NAME = 9;

	/**
	 * The feature id for the '<em><b>Lang</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME__LANG = 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME__TEXT = 1;

	/**
	 * The number of structural features of the the '<em>Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.TargetImpl <em>Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.TargetImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getTarget()
	 * @generated
	 */
	int TARGET = 10;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__CLASS_NAME = 0;

	/**
	 * The feature id for the '<em><b>Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__METHOD = 1;

	/**
	 * The feature id for the '<em><b>Package</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__PACKAGE = 2;

	/**
	 * The feature id for the '<em><b>Signature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__SIGNATURE = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET__TYPE = 4;

	/**
	 * The number of structural features of the the '<em>Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl <em>Probe</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getProbe()
	 * @generated
	 */
	int PROBE = 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Control Key</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__CONTROL_KEY = 2;

	/**
	 * The feature id for the '<em><b>Control Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__CONTROL_NAME = 3;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__TARGET = 4;

	/**
	 * The feature id for the '<em><b>Import</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__IMPORT = 5;

	/**
	 * The feature id for the '<em><b>Fragment At Class Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__FRAGMENT_AT_CLASS_SCOPE = 6;

	/**
	 * The feature id for the '<em><b>Fragment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__FRAGMENT = 7;

	/**
	 * The feature id for the '<em><b>Invocation Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE__INVOCATION_OBJECT = 8;

	/**
	 * The number of structural features of the the '<em>Probe</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBE_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.impl.ProbekitImpl <em>Probekit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitImpl
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getProbekit()
	 * @generated
	 */
	int PROBEKIT = 12;

	/**
	 * The feature id for the '<em><b>Probe</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT__PROBE = 0;

	/**
	 * The number of structural features of the the '<em>Probekit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBEKIT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.FragmentEnum <em>Fragment Enum</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.FragmentEnum
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getFragmentEnum()
	 * @generated
	 */
	int FRAGMENT_ENUM = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.probekit.internal.DataEnum <em>Data Enum</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.probekit.internal.DataEnum
	 * @see org.eclipse.hyades.models.probekit.internal.impl.ProbekitPackageImpl#getDataEnum()
	 * @generated
	 */
	int DATA_ENUM = 14;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Code <em>Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Code</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Code
	 * @generated
	 */
	EClass getCode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Code#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Code#getValue()
	 * @see #getCode()
	 * @generated
	 */
	EAttribute getCode_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.ControlKey <em>Control Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Control Key</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.ControlKey
	 * @generated
	 */
	EClass getControlKey();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.ControlKey#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.ControlKey#getName()
	 * @see #getControlKey()
	 * @generated
	 */
	EAttribute getControlKey_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.ControlKey#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.ControlKey#getValue()
	 * @see #getControlKey()
	 * @generated
	 */
	EAttribute getControlKey_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.ControlName <em>Control Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Control Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.ControlName
	 * @generated
	 */
	EClass getControlName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.ControlName#getLang <em>Lang</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lang</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.ControlName#getLang()
	 * @see #getControlName()
	 * @generated
	 */
	EAttribute getControlName_Lang();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.ControlName#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.ControlName#getText()
	 * @see #getControlName()
	 * @generated
	 */
	EAttribute getControlName_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Data <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Data
	 * @generated
	 */
	EClass getData();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Data#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Data#getName()
	 * @see #getData()
	 * @generated
	 */
	EAttribute getData_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Data#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Data#getType()
	 * @see #getData()
	 * @generated
	 */
	EAttribute getData_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Description <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Description
	 * @generated
	 */
	EClass getDescription();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Description#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Description#getValue()
	 * @see #getDescription()
	 * @generated
	 */
	EAttribute getDescription_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Description#getLang <em>Lang</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lang</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Description#getLang()
	 * @see #getDescription()
	 * @generated
	 */
	EAttribute getDescription_Lang();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Fragment <em>Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Fragment</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Fragment
	 * @generated
	 */
	EClass getFragment();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Fragment#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Fragment#getType()
	 * @see #getFragment()
	 * @generated
	 */
	EAttribute getFragment_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Fragment#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Fragment#getData()
	 * @see #getFragment()
	 * @generated
	 */
	EReference getFragment_Data();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.internal.Fragment#getCode <em>Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Code</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Fragment#getCode()
	 * @see #getFragment()
	 * @generated
	 */
	EReference getFragment_Code();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.FragmentAtClassScope <em>Fragment At Class Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Fragment At Class Scope</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.FragmentAtClassScope
	 * @generated
	 */
	EClass getFragmentAtClassScope();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.FragmentAtClassScope#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.FragmentAtClassScope#getValue()
	 * @see #getFragmentAtClassScope()
	 * @generated
	 */
	EAttribute getFragmentAtClassScope_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Import <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Import</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Import
	 * @generated
	 */
	EClass getImport();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Import#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Import#getText()
	 * @see #getImport()
	 * @generated
	 */
	EAttribute getImport_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.InvocationObject <em>Invocation Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Invocation Object</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.InvocationObject
	 * @generated
	 */
	EClass getInvocationObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.InvocationObject#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.InvocationObject#getName()
	 * @see #getInvocationObject()
	 * @generated
	 */
	EAttribute getInvocationObject_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Name <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Name
	 * @generated
	 */
	EClass getName_();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Name#getLang <em>Lang</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lang</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Name#getLang()
	 * @see #getName_()
	 * @generated
	 */
	EAttribute getName_Lang();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Name#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Name#getText()
	 * @see #getName_()
	 * @generated
	 */
	EAttribute getName_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Target <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Target</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Target
	 * @generated
	 */
	EClass getTarget();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Target#getClassName <em>Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Target#getClassName()
	 * @see #getTarget()
	 * @generated
	 */
	EAttribute getTarget_ClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Target#getMethod <em>Method</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Method</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Target#getMethod()
	 * @see #getTarget()
	 * @generated
	 */
	EAttribute getTarget_Method();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Target#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Package</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Target#getPackage()
	 * @see #getTarget()
	 * @generated
	 */
	EAttribute getTarget_Package();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Target#getSignature <em>Signature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signature</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Target#getSignature()
	 * @see #getTarget()
	 * @generated
	 */
	EAttribute getTarget_Signature();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.probekit.internal.Target#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Target#getType()
	 * @see #getTarget()
	 * @generated
	 */
	EAttribute getTarget_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Probe <em>Probe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Probe</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe
	 * @generated
	 */
	EClass getProbe();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probe#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getName()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probe#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getDescription()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_Description();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.internal.Probe#getControlKey <em>Control Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Control Key</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getControlKey()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_ControlKey();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probe#getControlName <em>Control Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Control Name</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getControlName()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_ControlName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probe#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Target</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getTarget()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_Target();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probe#getImport <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Import</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getImport()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_Import();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.internal.Probe#getFragmentAtClassScope <em>Fragment At Class Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Fragment At Class Scope</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getFragmentAtClassScope()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_FragmentAtClassScope();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probe#getFragment <em>Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Fragment</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getFragment()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_Fragment();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.probekit.internal.Probe#getInvocationObject <em>Invocation Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Invocation Object</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probe#getInvocationObject()
	 * @see #getProbe()
	 * @generated
	 */
	EReference getProbe_InvocationObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.probekit.internal.Probekit <em>Probekit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Probekit</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probekit
	 * @generated
	 */
	EClass getProbekit();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.probekit.internal.Probekit#getProbe <em>Probe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Probe</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.Probekit#getProbe()
	 * @see #getProbekit()
	 * @generated
	 */
	EReference getProbekit_Probe();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.probekit.internal.FragmentEnum <em>Fragment Enum</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Fragment Enum</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.FragmentEnum
	 * @generated
	 */
	EEnum getFragmentEnum();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.probekit.internal.DataEnum <em>Data Enum</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Data Enum</em>'.
	 * @see org.eclipse.hyades.models.probekit.internal.DataEnum
	 * @generated
	 */
	EEnum getDataEnum();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ProbekitFactory getProbekitFactory();

} //ProbekitPackage
