/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.probekit.internal.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.probekit.internal.ControlKey;
import org.eclipse.hyades.models.probekit.internal.ControlName;
import org.eclipse.hyades.models.probekit.internal.Description;
import org.eclipse.hyades.models.probekit.internal.Fragment;
import org.eclipse.hyades.models.probekit.internal.FragmentAtClassScope;
import org.eclipse.hyades.models.probekit.internal.Import;
import org.eclipse.hyades.models.probekit.internal.InvocationObject;
import org.eclipse.hyades.models.probekit.internal.Name;
import org.eclipse.hyades.models.probekit.internal.Probe;
import org.eclipse.hyades.models.probekit.internal.ProbekitPackage;
import org.eclipse.hyades.models.probekit.internal.Target;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Probe</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getControlKey <em>Control Key</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getControlName <em>Control Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getTarget <em>Target</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getImport <em>Import</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getFragmentAtClassScope <em>Fragment At Class Scope</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getFragment <em>Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.probekit.internal.impl.ProbeImpl#getInvocationObject <em>Invocation Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProbeImpl extends EObjectImpl implements Probe {
	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected EList name = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected EList description = null;

	/**
	 * The cached value of the '{@link #getControlKey() <em>Control Key</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getControlKey()
	 * @generated
	 * @ordered
	 */
	protected ControlKey controlKey = null;

	/**
	 * The cached value of the '{@link #getControlName() <em>Control Name</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getControlName()
	 * @generated
	 * @ordered
	 */
	protected EList controlName = null;

	/**
	 * The cached value of the '{@link #getTarget() <em>Target</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTarget()
	 * @generated
	 * @ordered
	 */
	protected EList target = null;

	/**
	 * The cached value of the '{@link #getImport() <em>Import</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImport()
	 * @generated
	 * @ordered
	 */
	protected EList import_ = null;

	/**
	 * The cached value of the '{@link #getFragmentAtClassScope() <em>Fragment At Class Scope</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFragmentAtClassScope()
	 * @generated
	 * @ordered
	 */
	protected FragmentAtClassScope fragmentAtClassScope = null;

	/**
	 * The cached value of the '{@link #getFragment() <em>Fragment</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFragment()
	 * @generated
	 * @ordered
	 */
	protected EList fragment = null;

	/**
	 * The cached value of the '{@link #getInvocationObject() <em>Invocation Object</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvocationObject()
	 * @generated
	 * @ordered
	 */
	protected InvocationObject invocationObject = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProbekitPackage.eINSTANCE.getProbe();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getName() {
		if (name == null) {
			name = new EObjectContainmentEList(Name.class, this, ProbekitPackage.PROBE__NAME);
		}
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDescription() {
		if (description == null) {
			description = new EObjectContainmentEList(Description.class, this, ProbekitPackage.PROBE__DESCRIPTION);
		}
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ControlKey getControlKey() {
		return controlKey;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetControlKey(ControlKey newControlKey, NotificationChain msgs) {
		ControlKey oldControlKey = controlKey;
		controlKey = newControlKey;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE__CONTROL_KEY, oldControlKey, newControlKey);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setControlKey(ControlKey newControlKey) {
		if (newControlKey != controlKey) {
			NotificationChain msgs = null;
			if (controlKey != null)
				msgs = ((InternalEObject)controlKey).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE__CONTROL_KEY, null, msgs);
			if (newControlKey != null)
				msgs = ((InternalEObject)newControlKey).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE__CONTROL_KEY, null, msgs);
			msgs = basicSetControlKey(newControlKey, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE__CONTROL_KEY, newControlKey, newControlKey));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getControlName() {
		if (controlName == null) {
			controlName = new EObjectContainmentEList(ControlName.class, this, ProbekitPackage.PROBE__CONTROL_NAME);
		}
		return controlName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTarget() {
		if (target == null) {
			target = new EObjectContainmentEList(Target.class, this, ProbekitPackage.PROBE__TARGET);
		}
		return target;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getImport() {
		if (import_ == null) {
			import_ = new EObjectContainmentEList(Import.class, this, ProbekitPackage.PROBE__IMPORT);
		}
		return import_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FragmentAtClassScope getFragmentAtClassScope() {
		return fragmentAtClassScope;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFragmentAtClassScope(FragmentAtClassScope newFragmentAtClassScope, NotificationChain msgs) {
		FragmentAtClassScope oldFragmentAtClassScope = fragmentAtClassScope;
		fragmentAtClassScope = newFragmentAtClassScope;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE, oldFragmentAtClassScope, newFragmentAtClassScope);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFragmentAtClassScope(FragmentAtClassScope newFragmentAtClassScope) {
		if (newFragmentAtClassScope != fragmentAtClassScope) {
			NotificationChain msgs = null;
			if (fragmentAtClassScope != null)
				msgs = ((InternalEObject)fragmentAtClassScope).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE, null, msgs);
			if (newFragmentAtClassScope != null)
				msgs = ((InternalEObject)newFragmentAtClassScope).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE, null, msgs);
			msgs = basicSetFragmentAtClassScope(newFragmentAtClassScope, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE, newFragmentAtClassScope, newFragmentAtClassScope));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFragment() {
		if (fragment == null) {
			fragment = new EObjectContainmentEList(Fragment.class, this, ProbekitPackage.PROBE__FRAGMENT);
		}
		return fragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InvocationObject getInvocationObject() {
		return invocationObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInvocationObject(InvocationObject newInvocationObject, NotificationChain msgs) {
		InvocationObject oldInvocationObject = invocationObject;
		invocationObject = newInvocationObject;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE__INVOCATION_OBJECT, oldInvocationObject, newInvocationObject);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInvocationObject(InvocationObject newInvocationObject) {
		if (newInvocationObject != invocationObject) {
			NotificationChain msgs = null;
			if (invocationObject != null)
				msgs = ((InternalEObject)invocationObject).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE__INVOCATION_OBJECT, null, msgs);
			if (newInvocationObject != null)
				msgs = ((InternalEObject)newInvocationObject).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProbekitPackage.PROBE__INVOCATION_OBJECT, null, msgs);
			msgs = basicSetInvocationObject(newInvocationObject, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProbekitPackage.PROBE__INVOCATION_OBJECT, newInvocationObject, newInvocationObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ProbekitPackage.PROBE__NAME:
					return ((InternalEList)getName()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE__DESCRIPTION:
					return ((InternalEList)getDescription()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE__CONTROL_KEY:
					return basicSetControlKey(null, msgs);
				case ProbekitPackage.PROBE__CONTROL_NAME:
					return ((InternalEList)getControlName()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE__TARGET:
					return ((InternalEList)getTarget()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE__IMPORT:
					return ((InternalEList)getImport()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE:
					return basicSetFragmentAtClassScope(null, msgs);
				case ProbekitPackage.PROBE__FRAGMENT:
					return ((InternalEList)getFragment()).basicRemove(otherEnd, msgs);
				case ProbekitPackage.PROBE__INVOCATION_OBJECT:
					return basicSetInvocationObject(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE__NAME:
				return getName();
			case ProbekitPackage.PROBE__DESCRIPTION:
				return getDescription();
			case ProbekitPackage.PROBE__CONTROL_KEY:
				return getControlKey();
			case ProbekitPackage.PROBE__CONTROL_NAME:
				return getControlName();
			case ProbekitPackage.PROBE__TARGET:
				return getTarget();
			case ProbekitPackage.PROBE__IMPORT:
				return getImport();
			case ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE:
				return getFragmentAtClassScope();
			case ProbekitPackage.PROBE__FRAGMENT:
				return getFragment();
			case ProbekitPackage.PROBE__INVOCATION_OBJECT:
				return getInvocationObject();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE__NAME:
				getName().clear();
				getName().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE__DESCRIPTION:
				getDescription().clear();
				getDescription().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE__CONTROL_KEY:
				setControlKey((ControlKey)newValue);
				return;
			case ProbekitPackage.PROBE__CONTROL_NAME:
				getControlName().clear();
				getControlName().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE__TARGET:
				getTarget().clear();
				getTarget().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE__IMPORT:
				getImport().clear();
				getImport().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE:
				setFragmentAtClassScope((FragmentAtClassScope)newValue);
				return;
			case ProbekitPackage.PROBE__FRAGMENT:
				getFragment().clear();
				getFragment().addAll((Collection)newValue);
				return;
			case ProbekitPackage.PROBE__INVOCATION_OBJECT:
				setInvocationObject((InvocationObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE__NAME:
				getName().clear();
				return;
			case ProbekitPackage.PROBE__DESCRIPTION:
				getDescription().clear();
				return;
			case ProbekitPackage.PROBE__CONTROL_KEY:
				setControlKey((ControlKey)null);
				return;
			case ProbekitPackage.PROBE__CONTROL_NAME:
				getControlName().clear();
				return;
			case ProbekitPackage.PROBE__TARGET:
				getTarget().clear();
				return;
			case ProbekitPackage.PROBE__IMPORT:
				getImport().clear();
				return;
			case ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE:
				setFragmentAtClassScope((FragmentAtClassScope)null);
				return;
			case ProbekitPackage.PROBE__FRAGMENT:
				getFragment().clear();
				return;
			case ProbekitPackage.PROBE__INVOCATION_OBJECT:
				setInvocationObject((InvocationObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProbekitPackage.PROBE__NAME:
				return name != null && !name.isEmpty();
			case ProbekitPackage.PROBE__DESCRIPTION:
				return description != null && !description.isEmpty();
			case ProbekitPackage.PROBE__CONTROL_KEY:
				return controlKey != null;
			case ProbekitPackage.PROBE__CONTROL_NAME:
				return controlName != null && !controlName.isEmpty();
			case ProbekitPackage.PROBE__TARGET:
				return target != null && !target.isEmpty();
			case ProbekitPackage.PROBE__IMPORT:
				return import_ != null && !import_.isEmpty();
			case ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE:
				return fragmentAtClassScope != null;
			case ProbekitPackage.PROBE__FRAGMENT:
				return fragment != null && !fragment.isEmpty();
			case ProbekitPackage.PROBE__INVOCATION_OBJECT:
				return invocationObject != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //ProbeImpl
