/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.internal.actions.OpenTimeBasedCorrelationViewPopupAction;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.views.SDViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * @author sleeloy
 *
 * This action class correlates an apache access log.  A time-based correlation is 
 * used.
 */
public class CorrelateLogAction extends OpenTimeBasedCorrelationViewPopupAction implements IRunnableWithProgress{

	private final String corrName = LogCorrelatorPlugin.getResourceString("CORR_NAME");

	private EObject mofObject;
	/**
	 * Returns the Mof object that represents the access log file.  This object will be correlated.
	 * @see org.eclipse.hyades.log.ui.internal.actions.OpenLogViewAction#getMofObject()
	 * @return EObject represents the access log file that will be correlated.
	 */
	public EObject getMofObject() {
		return mofObject;
	}
	
	/**
	 * Sets the Mof object that represents the access log file.  This object will be correlated.
 	 * @param EObject represents the access log file that will be correlated.
 	 */
	public void setMofObject(EObject eobject){
		this.mofObject = eobject;
		
	}

	/**
	 * The run method that updates the user of its progress.
	 * 
	 * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void run(IProgressMonitor monitor)
		throws InvocationTargetException, InterruptedException {
			monitor.worked(1);
			this.run();
			monitor.done();
	}

	/**
	 * This method does all the work.  The access log will be correlated based on Time.
	 * 
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (mofObject != null && mofObject instanceof EObject) {
			IWorkbenchPage persp = UIPlugin.getActivePage();

			try {
				SDViewer view = (SDViewer) persp.showView("org.eclipse.hyades.sd.ui.internal.views.SDViewer"); //$NON-NLS-1$


				if (view != null) {
//					LogCDrawUtils.setCurrentCorrelation(getCorrelation(corrName));

					view.addLoadViewPage((EObject) mofObject,Graph.LOGoverRECORD,getCorrelation(corrName));
	
				}
			} catch (Exception e) {
				String msg = LogCorrelatorPlugin.getResourceString("STR_LOAD_SD_ERR_");
				Status err =
					new Status(
						Status.WARNING,
						ResourcesPlugin.PI_RESOURCES,
						IResourceStatus.INTERNAL_ERROR,
						e.toString(),
						null);
				IWorkbenchWindow window = SDPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
				ErrorDialog.openError(window.getShell(), msg, "", err);
				e.printStackTrace();
			}
		}
		mofObject = null;
	}
	
	/**
	 * Cleans up all resources.
	 *
	 */
	public void dispose(){
	}
		

}
