/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.trace.internal.loader;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.internal.loader.*;
import org.eclipse.hyades.sd.ui.internal.model.*;

public class TRCAgentLoader extends TRCModelLoaderUtility implements IModelLoader
{
  private TRCAgentProxy trcAgentProxy = null;
  
  public TRCAgentLoader()
  {
  }
  
  public TRCAgentLoader(TRCAgentProxy agent, Graph inputGraph)
  {
    TRCAgentLoader loader = new TRCAgentLoader();
	trcAgentProxy = agent;
    graph = inputGraph;
  }
  
  public void setObjectAndGraph(Object mObject, Graph gr){
  	if (mObject instanceof TRCAgentProxy)
		trcAgentProxy = (TRCAgentProxy)mObject;
  	graph=gr;
  }
  
  private void setAgentProxy(TRCAgentProxy agentProxy)
  {
	trcAgentProxy = agentProxy;
  }
  private TRCAgentProxy getAgentProxy()
  {
    return trcAgentProxy;
  }
  public void load()
  {
  	  loadInvocationsIntoModel(trcAgentProxy,graph.getType());
  }
}
