/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Heap Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl#getRefOwner <em>Ref Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl#getRefTarget <em>Ref Target</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCHeapObjectImpl extends TRCObjectImpl implements TRCHeapObject {
	/**
	 * The cached value of the '{@link #getRefOwner() <em>Ref Owner</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefOwner()
	 * @generated
	 * @ordered
	 */
	protected EList refOwner = null;

	/**
	 * The cached value of the '{@link #getRefTarget() <em>Ref Target</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefTarget()
	 * @generated
	 * @ordered
	 */
	protected EList refTarget = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCHeapObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCHeapObject();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRefOwner() {
		if (refOwner == null) {
			refOwner = new EObjectWithInverseResolvingEList(TRCObjectReference.class, this, TracePackage.TRC_HEAP_OBJECT__REF_OWNER, TracePackage.TRC_OBJECT_REFERENCE__OWNER);
		}
		return refOwner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRefTarget() {
		if (refTarget == null) {
			refTarget = new EObjectWithInverseResolvingEList(TRCObjectReference.class, this, TracePackage.TRC_HEAP_OBJECT__REF_TARGET, TracePackage.TRC_OBJECT_REFERENCE__TARGET);
		}
		return refTarget;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_HEAP_OBJECT__IS_A:
					if (isA != null)
						msgs = ((InternalEObject)isA).eInverseRemove(this, TracePackage.TRC_CLASS__OBJECTS, TRCClass.class, msgs);
					return basicSetIsA((TRCClass)otherEnd, msgs);
				case TracePackage.TRC_HEAP_OBJECT__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_HEAP_OBJECT__PROCESS, msgs);
				case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
					return ((InternalEList)getRefOwner()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
					return ((InternalEList)getRefTarget()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_HEAP_OBJECT__IS_A:
					return basicSetIsA(null, msgs);
				case TracePackage.TRC_HEAP_OBJECT__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_HEAP_OBJECT__PROCESS, msgs);
				case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
					return ((InternalEList)getRefOwner()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
					return ((InternalEList)getRefTarget()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_HEAP_OBJECT__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__OBJECTS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_OBJECT__ID:
				return new Long(getId());
			case TracePackage.TRC_HEAP_OBJECT__SIZE:
				return new Integer(getSize());
			case TracePackage.TRC_HEAP_OBJECT__IS_A:
				if (resolve) return getIsA();
				return basicGetIsA();
			case TracePackage.TRC_HEAP_OBJECT__PROCESS:
				return getProcess();
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				return getRefOwner();
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				return getRefTarget();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_OBJECT__ID:
				setId(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_HEAP_OBJECT__SIZE:
				setSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_HEAP_OBJECT__IS_A:
				setIsA((TRCClass)newValue);
				return;
			case TracePackage.TRC_HEAP_OBJECT__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				getRefOwner().clear();
				getRefOwner().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				getRefTarget().clear();
				getRefTarget().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_OBJECT__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_OBJECT__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_HEAP_OBJECT__IS_A:
				setIsA((TRCClass)null);
				return;
			case TracePackage.TRC_HEAP_OBJECT__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				getRefOwner().clear();
				return;
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				getRefTarget().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_HEAP_OBJECT__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_HEAP_OBJECT__SIZE:
				return size != SIZE_EDEFAULT;
			case TracePackage.TRC_HEAP_OBJECT__IS_A:
				return isA != null;
			case TracePackage.TRC_HEAP_OBJECT__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_HEAP_OBJECT__REF_OWNER:
				return refOwner != null && !refOwner.isEmpty();
			case TracePackage.TRC_HEAP_OBJECT__REF_TARGET:
				return refTarget != null && !refTarget.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCHeapObjectImpl
