/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import org.eclipse.hyades.ui.util.IDisposable;

/**
 * Hyades navigator interface.
 * 
 * <p>Clients are not supposed to manipulate the navigator preferences and UI before 
 * its initialization.  See {@link #isInitialized()}
 * 
 * <p>This interface is not intended to be implemented by clients. Subclass 
 * {@link org.eclipse.hyades.ui.internal.navigator.Navigator} instead.   

 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.IResourceNavigator} class.
 * 
 * @author marcelop
 * @since 0.2.o
 */
public interface INavigator
extends IDisposable, ISetSelectionTarget
{
	/**
	 * Returns whether this navigator is initialized.
	 * @return boolean
	 */
	public boolean isInitialized();
	
	/**
	 * Returns the site for this navigator.
	 * @return the part site
	 */
	public IWorkbenchPartSite getSite();

	/**
	 * Returns the navigator's plugin.  This method should not return null.
	 * @return AbstractUIPlugin
	 */
	public AbstractUIPlugin getPlugin();
	
	/**
	 * Returns the current selection.
	 * @return a not <code>null</code> IStructuredSelection.
	 */
	public IStructuredSelection getStructuredSelection();
	
	/**
	 * Returns this navigator's viewer.
	 * @return StructuredViewer
	 */
	public StructuredViewer getViewer();
	
	/**
	 * Returns whether the navigator selection automatically tracks the active
	 * editor.
	 * @return <code>true</code> if linking is enabled, <code>false</code> if not  
	 */
	public boolean isLinkingEnabled();	
	
	/**
	 * Sets whether this navigator's selection automatically tracks the active editor.
	 * @param enabled <code>true</code> to enable, <code>false</code> to disable
	 */
	public void setLinkingEnabled(boolean enabled);
	
	/**
	 * Generic mechanism to notify the navigator that a change has happened.  There
	 * is no enforcement regarding the possible values for the type of the change.
	 */
	public void handleChange(int type);
	
	/**
	 * Returns the site for this navigator.
	 * @return the view site
	 */	
	public IViewSite getViewSite();	
	
	/**
	 * Updates the title text and title tool tip.  Should be called
	 * whenever the input of the viewer changes.
	 */
	public void updateTitle();
	
	/**
	 * Returns whether the navigator is showing projects and folders.
	 * @return <code>true</code> if is showing project and folders, 
	 * <code>false</code> if not.  
	 */	
	public boolean isShowingFolders();
	
}
