/*``````````````````````````````````````````````````````````````/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */

package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.*;
import java.net.*;

/**
 * @author dmorris
 * modified by:  mddunn 11/17/2003 for Hyades-O 1.2
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ClientSideReader extends Thread{
	
	public static final String ERROR_SSL_REQUEST_MADE = "-1"; //this is an error until SSL is supported
	public static final String ERROR_NO_TESTKEYS = "-2"; //this is an error until SSL is supported
	static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
	static int iConn = 0;
	static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");
	
	InputStream from_client;
	OutputStream to_client;
	InputStream from_server;
	OutputStream to_server;
	//Socket client = null;
	PeekSocket client = null;
	Socket httpServer = null;
//	SSLSocket sslServer = null;
//	SSLSocket spySocket = null;
	ServerSideReader serverReader = null;
	// this flag indicates whether we are operating an SSL connection
	boolean bSecure = false;
	boolean bNoPrintToServer = false;
	PacketWriter packetWriter = null;

	String destServer = null;
	int serverPort = 80;
	int iConnection = 0;
	static int isSSLClassAvailable = -1;
	static boolean foundTestKeys = false;
	

	
	ClientSideReader(PeekSocket client, PacketWriter packetWriter){
		try{
		
			this.from_client = client.getInputStream();
			this.to_client = client.getOutputStream();
			this.client = client;
			iConnection = getNextConnection();
			this.packetWriter = packetWriter;
			packetWriter.writeRecorderMessage(1, "Client Connected, connection " + iConnection );
					
		}
		catch (Exception e){
			packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + e);
			packetWriter.getAgentController().reportException(ClientSideReaderException,e);
		}
	
	}
	synchronized static int getNextConnection(){
		iConn++;
		return iConn;
	}
	
	public void run(){
		
		int bytes_read = 0;
		boolean socks_OK = false;
		String strReturn = null;
		 
		if (isSSLClassAvailable == -1)	{	
			isSSLClassAvailable = findSSLClass();
			if (isSSLClassAvailable == 1) {
				foundTestKeys = checkForTestKeys();
			}
		}

		try{
			
			byte[] buffer = new byte[client.getReceiveBufferSize()];
			socks_OK = processSocksRequest();
			if (socks_OK) {
				// TODO check for SSL Connection first before read
				bSecure = checkSSLByte();
				if (bSecure) {
					if (isSSLClassAvailable == 1)	{
						if (foundTestKeys) {
							SSLCheckClass thisSSLCheck = new SSLCheckClass(this);
							thisSSLCheck.checkForSecureConnectionRequest();
						}
						else  {
							// send message to UI 
							packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
							return;
						}
					}
					else {
						// send message to UI 
						packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_SSL_REQUEST_MADE);
						return;
					}
				}
				else 
					strReturn = checkForRegularConnectionRequest();
				while ((bytes_read = from_client.read(buffer)) != -1){
					sleep(1);
					bNoPrintToServer = false;
					int index = 0;
					String str = new String(buffer, 0, bytes_read);
					
					if (bSecure){
						packetWriter.writePacket(bSecure, true, iConnection, buffer, bytes_read);
						if (!bNoPrintToServer){
							to_server.write(buffer, 0, bytes_read);
							to_server.flush();
						}
					}
					if (!bSecure){
						packetWriter.writePacket(bSecure, true, iConnection, str.getBytes(), str.getBytes().length);
				
						if (!bNoPrintToServer && str.getBytes().length > 0){
							to_server.write(str.getBytes(), 0, str.getBytes().length);
							to_server.flush();
						}
					
					}
					
				}
			};
			packetWriter.writeCloseConnectionInfo(iConnection);
			if (httpServer != null)
				httpServer.close();
		}
		catch (Exception e) {
			packetWriter.writeCloseConnectionInfo(iConnection);
			try {
				if (httpServer != null)
					httpServer.close();
			}
			catch (IOException ioe){
				packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + ": "  + ioe);
			}
		}	
	}
	

	private boolean processSocksRequest() {
		boolean returnCode = false;
		int bytes_read = 0;
		int destPort = 0;
		int socksVersion = 0;
		int socksCommand = 0;
		String inetAddrStr = "";
		byte newInetAddress[] = new byte[4];
		int tmpInt = 0;
		InetAddress newAddr = null;
		
		// first read the entire socks header
		try {
			byte[] buffer = new byte[client.getReceiveBufferSize()];
			bytes_read = from_client.read(buffer);
			if (bytes_read < 8){
				// we have an error, must have at least 8 bytes
				returnCode = false;
			}
			else {
				int i=0;
				// have socks header, now process it
				for (i = 0; i < 8; i++){
					Byte tmpByte = new Byte(buffer[i]);
					switch(i){
					case 0:
						socksVersion = tmpByte.intValue();
						break;
					case 1:
						socksCommand = tmpByte.intValue();
						break;
					case 2:
						int tmp = 0;
						tmp = tmpByte.intValue();
						if (tmp < 0)
							tmp = tmp+256;
						destPort = (tmp*256) ;
						break;
					case 3:
						int tmp2 = 0;
						tmp2 = tmpByte.intValue();
						if (tmp2 < 0)
							tmp2 += 256;
						destPort += tmp2;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
						newInetAddress[i-4] = buffer[i];
						break;
					}	
				}
				// now must connect to IP address
				inetAddrStr = IP4ByteToString(newInetAddress);
				newAddr =  InetAddress.getByName(inetAddrStr);
				destServer = newAddr.getHostName();
				serverPort = destPort;
				httpServer = new Socket(newAddr, destPort);
				if (httpServer != null) {
					respondToClient(true);
					returnCode = true;
				}
				else {
					returnCode = false;
					// TODO write error msg to log 
					respondToClient(false);
					packetWriter.writeRecorderMessage(1, "Error connecting to Server:" + destServer + " Port: "+serverPort);
				}					
			}
		}
		catch (Exception e) {
			packetWriter.writeRecorderMessage(1, "Error Reading from Client");
			packetWriter.writeCloseConnectionInfo(iConnection);
			try {
				client.close();
			}
			catch (IOException ioe){
				packetWriter.writeRecorderMessage(1, "Error closing Client" + ioe);
			}
			
		}
		return returnCode;
	}
	private static String IP4ByteToString (byte myvar[]) {
		String strResult = "";		
		for (int i = 0; i < 4; i++) {
			if ((int)myvar[i] >= 0) {
				strResult += String.valueOf((int)myvar[i]);
			} else {
				strResult += String.valueOf(256 + (int)myvar[i]);
			}
			if (i < 3) {
				strResult += ".";
			}		
		}
		return strResult;
	}
	private void respondToClient(boolean flag) {
		byte[] reply_buff = new byte[8];
	
		reply_buff[0] = 0;
		if (flag == true){
			reply_buff[1] = 90;
		}
		else {
			reply_buff[1] = 91;
		}
		try {
			to_client.write(reply_buff,0, 8);
			to_client.flush();
		} catch (Exception e){
		}
	}

	private String checkForRegularConnectionRequest( ){
		
		String strReturn = null;
		//int index;	
		//int port = 80;
		//String destStr = null;
		boolean bFoundMessage = false;	

		try{
			// Note : already have open port to server
			//httpServer = new Socket(destStr, port);
			packetWriter.writeOpenConnectionInfo(bSecure, iConnection, destServer, serverPort, client, httpServer, null, null);
						
			to_server = httpServer.getOutputStream();
			from_server = httpServer.getInputStream();
						
			serverReader = new ServerSideReader(client,
												httpServer,
												from_server,
												to_client,
												 packetWriter,
												 iConnection,
												 bSecure,
												 httpServer.getReceiveBufferSize());
			serverReader.start();
	
		}
		catch (Exception e){
				packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + e);
				packetWriter.getAgentController().reportException(ClientSideReaderException,e);
				packetWriter.writeCloseConnectionInfo(iConnection);
				try {
					client.close();
					strReturn = null;
				}
				catch (IOException ioe){
					packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + iConnection + ": "  + ioe);
				}
		}
		return strReturn;					
	}
	public int findSSLClass() {
		int gotSSL = -1;

		try{
				Class cl = Class.forName("javax.net.ssl.SSLSocket");
				gotSSL = 1;
			}
			catch (ClassNotFoundException cnf){
				gotSSL = 0;			
			}
		return gotSSL;
	}
	boolean checkSSLByte() {
		boolean isSSL = false;
		int ssl_byte = 0;
		//TODO must mark beginning of buffer, read 1 byte and check if the
		// byte = 128 or 20 or 21 or 22 or 23
		// if so, must convert client to spysocket and server to SSLSocketFactory socket
		// and reset() the buffer to beginning 

		try {
			ssl_byte = client.peek();
		}
		catch (IOException e) {
			packetWriter.writeRecorderMessage(2, "exception checking for SSL Connection: " + e);
		}
		// packetWriter.writeRecorderMessage(1, "ssl_byte is: " + ssl_byte );
		if ((ssl_byte == 128) || (ssl_byte == 20) || (ssl_byte == 21) 
				|| (ssl_byte == 22) || (ssl_byte == 23)) {
				
			isSSL = true;
			bSecure = true;
		}
		else {
			bSecure = false;
			isSSL = false;
		}
		return isSSL;
	}
	boolean checkForTestKeys() {
		boolean foundIt = false;
		File keysFile = new File("C:\\testkeys");
		foundIt = keysFile.exists();
		return foundIt;
	}
}