/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.config.outputters;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.config.StaticParserWrapper;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author eclipse
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class StaticParserOutputter extends ProcessUnit implements IOutputter {

	/* The loader where all of the events will be forwarded */
	private Log outLogger; 

	public void update() throws AdapterInvalidConfig {
		
		String key = null;
		try {
			/* first get the basic configuration set */
			super.update();

			/* Retrieve our config */
			Element element = getConfiguration();

			// This outputter is configured with a sub element of the config
			NodeList outputters = element.getChildNodes();
			Element outputterInstance = null;
			

			for (int i = 0; i < outputters.getLength(); i++) {
				if (outputters.item(i).getNodeType() == Node.ELEMENT_NODE) {
					outputterInstance = (Element) outputters.item(i);
				}
			}

			// Get attributes				
			if (outputterInstance.hasAttribute(Messages.getString("HyadesGAStaticParserLoggerKeyName"))) {
				key = outputterInstance.getAttribute(Messages.getString("HyadesGAStaticParserLoggerKeyName"));
			}
		}
		finally {
			if(key!=null) {
				outLogger = StaticParserWrapper.getLogInstance(key);
			}
		}	
	}


	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(java.lang.Object[])
	 */
	public Object[] processEventItems(Object[] msgs) {
		
		/* If we have no input or we have nowhere to put it then we will just return what we got. */
		if (msgs==null || outLogger==null) {
			return msgs;
		}
		return processCBEs((ICommonBaseEvent[]) msgs);

	}

	/**
	 * Process the CBE events passed in.
	 * @param events CBE events to process
	 * @return ICommonBaseEvent[]
	 */
	private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] events) {
		
		for (int i = 0; i < events.length; i++)	{
			if (events[i] != null) {
							
				try {
					// Write CBE to logging agent
					outLogger.trace(events[i]);;
				} catch (Exception ioe) {
				}
			}
		}
		return events;
	}


	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#testProcessEventItems(java.lang.Object[])
	 */
	public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
		if(!(msgs instanceof ICommonBaseEvent[])) {
			throw new AdapterInvalidConfig("This outputter will only accept arrays of ICommonBaseEvent");
		}
		return msgs;
	}	
	
}
