/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

/**
 * CONTEXT_ID topp0000 for Profiling Options preference page.
 */

public class TraceOptionsPreferencePage {

	private TraceProfileOptionsUI _options;
	private IPreferenceStore _preferenceStore;
	private PreferencePage _preferencePage;

	public TraceOptionsPreferencePage(IPreferenceStore preferenceStore, PreferencePage preferencePage) {
		super();
		_preferenceStore = preferenceStore;
		_preferencePage = preferencePage;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId() + ".topp0000");

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_options = new TraceProfileOptionsUI();
		_options.createControl(composite);
		_options.setPreferencePage(_preferencePage);

		_options.enableButtons();

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return _preferenceStore;
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
	
		_options.setHeap(
			_preferenceStore.getDefaultBoolean(TraceConstants.PROF_HEAP_STAT));
		_options.setHeapDetails(
			_preferenceStore.getDefaultBoolean(TraceConstants.PROF_HEAP_INST));			
		_options.setExecution(
			_preferenceStore.getDefaultBoolean(TraceConstants.PROF_EXECUTION));
		
		_options.setExecutionBoundary(
			_preferenceStore.getDefaultBoolean(TraceConstants.PROF_EXECUTION_BOUNDARY));
		_options.setCollectionDepth(
			_preferenceStore.getDefaultString(TraceConstants.COLLECT_DEPTH));
			
		_options.setExecutionStatistic(
			_preferenceStore.getDefaultBoolean(TraceConstants.PROF_EXEC_STAT));			
		_options.setExecutionFlow(
			!_preferenceStore.getDefaultBoolean(TraceConstants.PROF_EXEC_STAT));
					
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		UIPlugin.getDefault().savePluginPreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {

       _options.storeValues();
	}
}
