/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.internal.codegen;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.internal.codegen.ImportManager;
import org.eclipse.hyades.ui.internal.util.StringUtil;

import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.test.http.runner.*;

class GenTestSuite
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "\t\t" + NL;
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";" + NL;
  protected final String TEXT_4 = NL + NL + "/**" + NL + " * Generated code for the test suite <b>";
  protected final String TEXT_5 = "</b> located at" + NL + " * <i>";
  protected final String TEXT_6 = "</i>";
  protected final String TEXT_7 = ".";
  protected final String TEXT_8 = NL + " *" + NL + " * ";
  protected final String TEXT_9 = NL + " */" + NL + "public class ";
  protected final String TEXT_10 = NL + "extends ";
  protected final String TEXT_11 = NL + "{" + NL + "\t/**" + NL + "\t * Constructor for ";
  protected final String TEXT_12 = "." + NL + "\t * @param name" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_13 = "(String name)" + NL + "\t{" + NL + "\t\tsuper(name);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Returns the JUnit test suite that implements the <b>";
  protected final String TEXT_14 = "</b>" + NL + "\t * definition." + NL + "\t */" + NL + "\tpublic static Test suite()" + NL + "\t{";
  protected final String TEXT_15 = "\t\t";
  protected final String TEXT_16 = " ";
  protected final String TEXT_17 = " = new ";
  protected final String TEXT_18 = "(\"";
  protected final String TEXT_19 = "\");" + NL + "\t\t";
  protected final String TEXT_20 = ".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"";
  protected final String TEXT_21 = "\");" + NL + "\t\t";
  protected final String TEXT_22 = NL + "        ";
  protected final String TEXT_23 = NL + NL + "\t\treturn ";
  protected final String TEXT_24 = ";" + NL + "\t}" + NL + "\t" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#setUp()" + NL + "\t */" + NL + "\tprotected void setUp()" + NL + "\tthrows ";
  protected final String TEXT_25 = NL + "\t{" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#tearDown()" + NL + "\t */" + NL + "\tprotected void tearDown()" + NL + "\tthrows ";
  protected final String TEXT_26 = NL + "\t{" + NL + "\t}\t";
  protected final String TEXT_27 = NL + NL + "/**" + NL + " * ";
  protected final String TEXT_28 = NL + " *" + NL + " * ";
  protected final String TEXT_29 = NL + " * ";
  protected final String TEXT_30 = NL + " * @throws ";
  protected final String TEXT_31 = NL + " */" + NL + "\tpublic void ";
  protected final String TEXT_32 = "()" + NL + "\tthrows ";
  protected final String TEXT_33 = NL + "\t{" + NL + "\t\t";
  protected final String TEXT_34 = NL + "\t}";
  protected final String TEXT_35 = NL;
  protected final String TEXT_36 = "\t/*********************" + NL + "\t *  Member variables *" + NL + "\t *********************/" + NL + "\tstatic protected ";
  protected final String TEXT_37 = "[] m_httpCookieCache;" + NL + "\tstatic protected ";
  protected final String TEXT_38 = "[] m_httpExecutor;" + NL + "\tprotected ";
  protected final String TEXT_39 = " rand = new Random();" + NL + "\t" + NL + "\t/*********************" + NL + "\t *    Extra Methods  *" + NL + "\t *********************/" + NL + "\tpublic void populateCookieCache(";
  protected final String TEXT_40 = " cookies)" + NL + "\t{" + NL + "\t\t//By default, the cookie cache is created empty.  To add new cookies, use the following" + NL + "\t\t//cookies.AddCookie(name, value, domain, path, expires, bSecure);" + NL + "\t}" + NL + "\t" + NL + "\tprotected void executeRequest(";
  protected final String TEXT_41 = " request)" + NL + "\tthrows ";
  protected final String TEXT_42 = NL + "\t{" + NL + "\t\tif (m_httpExecutor == null || m_httpCookieCache == null)" + NL + "\t\t\tinitializeTest();" + NL + "" + NL + "\t\tint nUser = ";
  protected final String TEXT_43 = ".getCurrentUser(this);" + NL + "\t\tm_httpCookieCache[nUser].DynamicGetCookie(request);" + NL + "\t\t";
  protected final String TEXT_44 = " response = m_httpExecutor[nUser].execute(request);" + NL + "\t\t" + NL + "\t\tString text = \"rc=\" + Integer.toString(response.getCode());" + NL + "\t\tif(response.getDetail() != null)" + NL + "\t\t\ttext = \"\\n\\n\" + response.getDetail();" + NL + "" + NL + "\t\t//If (response.getCode() < 0) then there was an error when executing the request" + NL + "\t\tif(response.getCode() < 0)" + NL + "\t\t\tthrow new ";
  protected final String TEXT_45 = "(text);" + NL + "" + NL + "\t\tm_httpCookieCache[nUser].DynamicSetCookie(request, response);" + NL + "\t\t" + NL + "\t\t//If (response.getCode() < 400) then the request has failed." + NL + "\t\tassertTrue(text, response.getCode() < 400 && response.getCode() > 0);" + NL + "\t}" + NL + "\t" + NL + "\tsynchronized protected void initializeTest() " + NL + "\t{" + NL + "\t\tint nTotal = ";
  protected final String TEXT_46 = ".getTotalUsers(this);" + NL + "\t\tif (m_httpCookieCache == null)" + NL + "\t\t{" + NL + "\t\t\tm_httpCookieCache = new ";
  protected final String TEXT_47 = "[nTotal];" + NL + "\t\t\tfor (int i = 0; i < nTotal; i++)" + NL + "\t\t\t{ " + NL + "\t\t\t\tm_httpCookieCache[i] = new ";
  protected final String TEXT_48 = "();" + NL + "\t\t\t\tpopulateCookieCache(m_httpCookieCache[i]);" + NL + "\t\t\t}" + NL + "\t\t\t " + NL + "\t\t}" + NL + "\t\tif (m_httpExecutor == null)" + NL + "\t\t{\t" + NL + "\t\t\tm_httpExecutor = new ";
  protected final String TEXT_49 = "[nTotal];" + NL + "\t\t\tfor (int i = 0; i < nTotal; i++)" + NL + "\t\t\t{" + NL + "\t\t\t\tm_httpExecutor[i] = new ";
  protected final String TEXT_50 = "();" + NL + "\t\t\t}" + NL + "\t\t}" + NL + "\t}\t" + NL + "\t" + NL + "\tprotected long calcThinkTime(long think, int var) " + NL + "\t{" + NL + "\t\tif (var > 0 && var < 99) {" + NL + "\t\t\tlong delta = think * var / 100;" + NL + "\t\t\tthink += (rand.nextInt((int) delta * 2) - delta);" + NL + "\t\t}" + NL + "\t\treturn think;" + NL + "\t}" + NL + "\t}";

	public String generate(ITestSuite testSuite, final Helper helper)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	class MethodBodyGenerator
	{	
		int think_time = Integer.parseInt( HttpPreferenceUtil.getInstance().getDefaultThinkTime());
		int variance = ( think_time > 0 ) ? Integer.parseInt( HttpPreferenceUtil.getInstance().getDefaultVariance()) : 0;		 
	
		public StringBuffer generate(ITestCase testCase)
		{
			StringBuffer sb = generateHttp(testCase);
			if(sb == null)
				sb = generateDefault();
			return sb;
		}
		
		protected StringBuffer generateHttp(ITestCase testCase)
		{
			RequestHelper requestHelper = new RequestHelper();
			requestHelper.setTestCase(testCase);
			HttpRequest request = requestHelper.createHttpRequest();
			if(request == null)
				return null;
		
			StringBuffer sb = new StringBuffer();
			
			sb.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")).append(" request = new ").append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")).append("();");
			String value = null;

			value = request.getMethod();
			if(value != null)
				sb.append(NL).append("request.setMethod(\"").append(adjustString(value)).append("\");");
	
			// aberns: we oly want to add this call if 'getThinkTime' and 'setThinkTime' methods
			// exist in ther HTTPRequest, to ensure compatiblity with older tests. The same applies to HTTPExecutor. 
			

			if( think_time > 0 )
			{				
				long thinkTime = request.getThinkTime();
				if( thinkTime == -1 )
					thinkTime = think_time;
				if( thinkTime > 0 )
					sb.append("\n").append("request.setThinkTime( calcThinkTime( ").append( thinkTime ).append(",").append(variance).append(" ));");				
			}
			
			value = request.getVersion();
			if(value != null)
				sb.append(NL).append("request.setVersion(\"").append(adjustString(value)).append("\");");

			value = request.getHost();
			if(value != null)
				sb.append(NL).append("request.setHost(\"").append(adjustString(value)).append("\");");
			
			if(request.getPort() > 0)
				sb.append(NL).append("request.setPort(").append(request.getPort()).append(");");

			value = request.getAbsolutePath();
			if(value != null)
				sb.append(NL).append("request.setAbsolutePath(\"").append(adjustString(value)).append("\");");
				
			value = request.getBody();
			if(value != null)
				sb.append(NL).append("request.setBody(\"").append(adjustString(value)).append("\");");
			
			if (request.getPageNumber() >= 0)
				sb.append(NL).append("request.setPageNumber(").append(request.getPageNumber()).append(");");

			String pageEnum = helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_UNDEFINED";

			//dynamically determine the pageEnum
			IVariable pageOrder = null;
			for (Iterator it = testCase.getVariables().iterator(); it.hasNext();)
			{
				IVariable var = (IVariable) it.next();
				if (var.getName().equals("pageOrder"));
				{
					pageOrder = var;
					break;
				}
			}
			if (pageOrder != null)
			{
				if (pageOrder.getInitialValue().equals("PAGE_ONLY"))
					pageEnum = helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_ONLY";
				else if (pageOrder.getInitialValue().equals("PAGE_START"))
					pageEnum = helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_START";
				else if (pageOrder.getInitialValue().equals("PAGE_MID"))
					pageEnum = helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_MID";
				else if (pageOrder.getInitialValue().equals("PAGE_END"))
					pageEnum = helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_END";
			}
	
			sb.append(NL).append("request.setPageOrder(").append(pageEnum).append(");");  	

			
			sb.append(NL).append("request.setSecure(").append(request.getSecure()).append(");");
			
			HttpHeader[] headers = request.getHeaders();
			if(headers.length > 0)
			{
				for (int i = 0, maxi = headers.length; i < maxi; i++)
				{
					value = headers[i].getName();
					if(value == null)
						continue;
					sb.append(NL).append(NL);					
					
					if(i == 0 )
						sb.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpHeader")).append(" header;").append(NL);					
					
					sb.append("header = new ").append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpHeader")).append("();");
					
					sb.append(NL).append("header.setName(\"").append(adjustString(value)).append("\");");
					
					value = headers[i].getValue();
					if(value != null)
						sb.append(NL).append("header.setValue(\"").append(adjustString(value)).append("\");");
						
					sb.append(NL).append("request.addHeader(header);");
				}
			}
			sb.append(NL);
			sb.append(NL).append("executeRequest(request);");
	
			return sb;
		}

		protected StringBuffer generateDefault()
		{
			StringBuffer sb = new StringBuffer();
			sb.append("// Enter your code here");
			return sb;
		}
		
		protected String adjustString(String string)
		{
			string = StringUtil.replace(string, "\"", "\\\"");
			return string;
		}
	}

    
	class InvocationGenerator
	{
		private String hyadesTestSuiteClassName;
		
		public InvocationGenerator(String hyadesTestSuiteClassName)
		{
			this.hyadesTestSuiteClassName = hyadesTestSuiteClassName;
		}
		
		public StringBuffer generate(String owner, List actions)
		{
			StringBuffer code = new StringBuffer();
			StringBuffer sb = new StringBuffer();
			for(Iterator i=actions.iterator(); i.hasNext();)
			{
				IAction action = (IAction)i.next();
				
				if(action instanceof ITestInvocation)
					sb = generate(owner, (ITestInvocation)action);
				else if(action instanceof ILoop)
					sb = generate(owner, (ILoop)action);
				else
					continue;

				if (sb == null)
				{ //error condition
					code.append(NL).append("//ERROR: No definition found for test element: ").append(action.getName()).append(NL).append(NL);
					continue;	
				}
				if(sb.length() == 0)
					continue;
				
				if(code.length() > 0)
					code.append(NL).append(NL);
				code.append(sb.toString());
			}

			return code;
		}
		
		private StringBuffer generate(String owner, ITestInvocation testInvocation)
		{
			StringBuffer sb = new StringBuffer(owner).append(".addTest(");
			ITest invokedTest = testInvocation.getInvokedTest();
			if(invokedTest == null)
				return null;
				
			if(invokedTest instanceof ITestSuite)
			{
				sb.append("((").append(hyadesTestSuiteClassName).append(")").append(helper.getImportedName(invokedTest.getImplementor().getResource())).append(".suite())");
			}
			else
			{
				ITestCase testCase = (ITestCase)invokedTest;
				String identifier = testCase.getImplementor().getResource();
				if(identifier == null)
					identifier = helper.retrieveIdentifierName(testCase, "METHOD");

				sb.append("new ").append(helper.getImportedName(testCase.getOwner().getImplementor().getResource())).append("(\"").append(identifier).append("\")");
				sb.append(".setId(\"").append(invokedTest.getId()).append("\")");
			}
			sb.append(".setTestInvocationId(\"").append(testInvocation.getId()).append("\")");			
			if(!testInvocation.isSynchronous())
				sb.append(".setSynchronous(false)");
			
			return sb.append(");");
		}

		private StringBuffer generate(String owner, ILoop loop)
		{
			String identifier = helper.retrieveIdentifierName(loop, "METHOD");
			String name = loop.getName();
			if(name == null)
				name = "";
			else
				name = "\"" + name + "\"";
				
			StringBuffer sb = new StringBuffer(hyadesTestSuiteClassName).append(" ").append(identifier);
			sb.append(" = new ").append(hyadesTestSuiteClassName).append("(").append(name).append(");").append(NL);
			sb.append(owner).append(".addTest(new ").append(helper.getImportedName("junit.extensions.RepeatedTest")).append("(").append(identifier).append(", ").append(loop.getCondition().getConstraint()).append("));").append(NL);
			sb.append(identifier).append(".setId(\"").append(loop.getId()).append("\")");
			if(!loop.isSynchronous())
				sb.append(".setSynchronous(false)");				
			sb.append(";");
			
			//search for page data
			IProperty prop = loop.getActionProperties().getPropertyByName("HTTPPAGE");
			if (prop != null)
			{
				//Because we can't go back from the ITest (in MethodBodyGenerator), we will determine page enumerations here 
				//and store them in a variable (to be retrieved in MethodBody Generator)
				List actions = loop.getBlock().getActions();
				if (actions.size() >= 1)
				{
					if (actions.size() == 1)
					{//PAGE_ONLY
						if (actions.get(0) instanceof ITestInvocation)
						{ 
							ITest test = ((ITestInvocation)actions.get(0)).getInvokedTest();
							if (test != null)
							{
								IVariable var = HyadesFactory.INSTANCE.createVariable();
								var.setInitialValue("PAGE_ONLY");
								var.setName("pageOrder");
								test.getVariables().add(var);
							}											
						}
					}
					for (int nCount = 0; nCount < actions.size(); nCount++)
					{
						Object o = actions.get(nCount);
						if (o instanceof ITestInvocation)
						{
							ITest itest = ((ITestInvocation)o).getInvokedTest();
							if (itest != null)
							{
								IVariable var = HyadesFactory.INSTANCE.createVariable();
								
								if (nCount == 0)
									var.setInitialValue("PAGE_START");
								else if (nCount == actions.size() - 1)
									var.setInitialValue("PAGE_END");
								else
									var.setInitialValue("PAGE_MID");
								var.setName("pageOrder");
								itest.getVariables().add(var);
							}
						}							
					}
					
				}
					
			}
			return sb.append(NL).append(NL).append(generate(identifier, loop.getBlock().getActions()).toString());
		}
	}

    
	String packageName = helper.getPackageName(testSuite);
	String className = helper.retrieveClassName(testSuite);
	String description = testSuite.getDescription();
	if(description != null)
		description = StringUtil.replace(description.trim(), NL, NL + " * ");
	else
		description = "";
		
	helper.setImportManager(new ImportManager(packageName));
	helper.getImportedName(packageName + "." + className);

    stringBuffer.append(TEXT_2);
    stringBuffer.append(packageName);
    stringBuffer.append(TEXT_3);
    
	helper.addImport("junit.framework.Test");
	helper.addImport("org.eclipse.hyades.test.common.junit.DefaultTestArbiter");
	helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestCase");
	helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
	helper.markImportLocation(stringBuffer);

	final String hyadesTestSuiteClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
	final String hyadesTestCaseClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestCase");
	String exceptionClassName = helper.getImportedName("java.lang.Exception");
	String filePath = helper.getFilePath(testSuite);

    stringBuffer.append(TEXT_4);
    stringBuffer.append(helper.getLabel(testSuite));
    if(filePath != null){
    stringBuffer.append(TEXT_5);
    stringBuffer.append(filePath);
    stringBuffer.append(TEXT_6);
    }
    stringBuffer.append(TEXT_7);
    if(description.length() > 0){
    stringBuffer.append(TEXT_8);
    stringBuffer.append(description);
    }
    stringBuffer.append(TEXT_9);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_10);
    stringBuffer.append(hyadesTestCaseClassName);
    stringBuffer.append(TEXT_11);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_12);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_13);
    stringBuffer.append(helper.getLabel(testSuite));
    stringBuffer.append(TEXT_14);
     
		String javaElement = helper.retrieveIdentifierName(testSuite, "SUITE"); 
		String code = new InvocationGenerator(hyadesTestSuiteClassName).generate(javaElement, testSuite.getImplementor().getBlock().getActions()).toString();


    stringBuffer.append(TEXT_15);
    stringBuffer.append(hyadesTestSuiteClassName);
    stringBuffer.append(TEXT_16);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_17);
    stringBuffer.append(hyadesTestSuiteClassName);
    stringBuffer.append(TEXT_18);
    stringBuffer.append(helper.getLabel(testSuite));
    stringBuffer.append(TEXT_19);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_20);
    stringBuffer.append(testSuite.getId());
    stringBuffer.append(TEXT_21);
    stringBuffer.append(TEXT_22);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_23);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_24);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_25);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_26);
    
	MethodBodyGenerator methodBodyGenerator = new MethodBodyGenerator();
	for(Iterator i=testSuite.getITestCases().iterator(); i.hasNext();)
	{
		ITestCase testCase = (ITestCase)i.next();
		
		code = methodBodyGenerator.generate(testCase).toString();
		String identifier = testCase.getImplementor().getResource();
		if(identifier == null)
			identifier = helper.retrieveIdentifierName(testCase, "METHOD");

		if(identifier != null)
		{
			description = testCase.getDescription();
			description = StringUtil.replace(description, NL, NL + " * ");

    stringBuffer.append(TEXT_27);
    stringBuffer.append(helper.getLabel(testCase));
    if(description != null){
    stringBuffer.append(TEXT_28);
    stringBuffer.append(description);
    stringBuffer.append(TEXT_29);
    }
    stringBuffer.append(TEXT_30);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_31);
    stringBuffer.append(identifier);
    stringBuffer.append(TEXT_32);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_33);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_34);
    
		}
	}

    stringBuffer.append(TEXT_35);
    stringBuffer.append(TEXT_36);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
    stringBuffer.append(TEXT_37);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
    stringBuffer.append(TEXT_38);
    stringBuffer.append(helper.getImportedName("java.util.Random"));
    stringBuffer.append(TEXT_39);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
    stringBuffer.append(TEXT_40);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest"));
    stringBuffer.append(TEXT_41);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_42);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.internal.util.HttpTestUtil"));
    stringBuffer.append(TEXT_43);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpResponse"));
    stringBuffer.append(TEXT_44);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_45);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.internal.util.HttpTestUtil"));
    stringBuffer.append(TEXT_46);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
    stringBuffer.append(TEXT_47);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
    stringBuffer.append(TEXT_48);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
    stringBuffer.append(TEXT_49);
    stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
    stringBuffer.append(TEXT_50);
    helper.emitSortedImports();
    
    return stringBuffer.toString();
  }
}
