/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.importWizard;

import java.io.File;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

public class HttpImportPage 
extends WizardPage implements IWizardPage, ModifyListener
{
	protected Combo inputFileCombo;
	private Button infileBrowseButton;

	protected Combo targetFolderCombo;
	private Button outfolderBrowseButton;
	private Button importAsSeparateTestcase;

	private boolean inputOK = false;
	private boolean outputOK = false;
	
	private Text testcaseBaseName;

	/**
	 * Constructor for HttpImportPage.
	 */
	public HttpImportPage()
	{
		super(HttpImportPage.class.getName() + "___1");
		setTitle(TestHttpPlugin.getString("Importer.Title"));
	}

	/*
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite myparent)
	{
		String[] tempStringArray;

		setDescription(TestHttpPlugin.getString("Importer.Description"));
		Composite parent = new Composite(myparent, SWT.NULL);

		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		parent.setLayout(layout);

		Label label = new Label(parent, SWT.NULL);
		label.setText(TestHttpPlugin.getString("Origin.Label"));

		Composite twoCol = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.makeColumnsEqualWidth = false;
		twoCol.setLayout(layout);
		twoCol.setLayoutData(GridDataUtil.createHorizontalFill());
		
		inputFileCombo = new Combo(twoCol, SWT.NULL);
		inputFileCombo.setLayoutData(GridDataUtil.createHorizontalFill());
		inputFileCombo.addModifyListener(this);

		tempStringArray = HttpPreferenceUtil.getInstance().getInfileHistory();
		for (int t = tempStringArray.length; t > 0; t--)
			inputFileCombo.add(tempStringArray[t - 1]);

		infileBrowseButton = new Button(twoCol, SWT.PUSH | SWT.LEFT);
		infileBrowseButton.setText(TestHttpPlugin.getString("inFileBrowse.Label"));
		infileBrowseButton.addSelectionListener(new SelectionAdapter()
		{
			public void widgetSelected(SelectionEvent e)
			{
				String tempInputFileName = getInputFileName();
				if (tempInputFileName != null)
					inputFileCombo.setText(tempInputFileName);
			}
		});

		importAsSeparateTestcase = new Button(parent, SWT.CHECK);
		importAsSeparateTestcase.setText(TestHttpPlugin.getString("ImportAsSeparate.Label"));
		importAsSeparateTestcase.setSelection(HttpPreferenceUtil.getInstance().getImportAsSeparate());

		label = new Label(parent, SWT.NULL);

		label = new Label(parent, SWT.NULL);
		label.setText(TestHttpPlugin.getString("Destination.Label"));

		twoCol = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.makeColumnsEqualWidth = false;
		twoCol.setLayout(layout);
		twoCol.setLayoutData(GridDataUtil.createHorizontalFill());
		
		targetFolderCombo = new Combo(twoCol, SWT.NULL);
		targetFolderCombo.setLayoutData(GridDataUtil.createHorizontalFill());
		targetFolderCombo.addModifyListener(this);
				
		tempStringArray = HttpPreferenceUtil.getInstance().getTargetHistory();
		for (int t = tempStringArray.length; t > 0; t--)
			targetFolderCombo.add(tempStringArray[t - 1]);

		outfolderBrowseButton = new Button(twoCol, SWT.PUSH);
		outfolderBrowseButton.setText(TestHttpPlugin.getString("outFolderBrowse.Label"));
		outfolderBrowseButton.addSelectionListener(new SelectionAdapter()
		{
			public void widgetSelected(SelectionEvent e)
			{
				IPath tempOutputFileFolderName = (IPath) getOutputFolderName();
				if (tempOutputFileFolderName != null)
					targetFolderCombo.setText(tempOutputFileFolderName.toString());
			}
		});

		label = new Label(parent, SWT.NULL);
		label.setText(TestHttpPlugin.getString("Importer.TestcaseBaseName"));
		testcaseBaseName = new Text(parent, SWT.BORDER);
		testcaseBaseName.setLayoutData(GridDataUtil.createHorizontalFill());
		
		String value = HttpPreferenceUtil.getInstance().getImportTestcaseBaseName();
		if(value == null)
			value = "";
		testcaseBaseName.setText(value);
		testcaseBaseName.setText(HttpPreferenceUtil.getInstance().getImportTestcaseBaseName());		
		testcaseBaseName.addModifyListener(this);

		setControl(parent);
		setPageComplete(false);
	}

	public void modifyText(ModifyEvent event)
	{
		inputOK = false;
		IContainer workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();		
		File tempFile = new File(inputFileCombo.getText().trim());
		if (tempFile.exists() && tempFile.canRead())
		{
			inputOK = true;
			outputOK = (testcaseBaseName.getText().trim().length() > 0);
			
			if(outputOK)
			{
				if (!targetFolderCombo.getText().trim().equals(""))
				{
					Path path = new Path(targetFolderCombo.getText());
					if (workspaceRoot.exists(path))
						outputOK = true;
				}
			}
		}
		
		setPageComplete(inputOK && outputOK);
		getContainer().updateButtons();
	}

	protected String getInputFileName()
	{
		FileDialog dialog = new FileDialog(getShell());
		dialog.setFilterExtensions(new String[] { "*.http", "*.*" });
		dialog.setText(TestHttpPlugin.getString("RecordingFileLocation.Heading"));
		if(inputFileCombo.getText().trim().length() > 0)
			dialog.setFilterPath(inputFileCombo.getText());
			
		String res = dialog.open();
		return res;
	}

	public String getFrom()
	{		
		return inputFileCombo.getText();
	}
	
	public String getTestcaseBaseName()
	{
		HttpPreferenceUtil.getInstance().setImportAsSeparate(importAsSeparateTestcase.getSelection());
		HttpPreferenceUtil.getInstance().setImportTestcaseBaseName(testcaseBaseName.getText());

		return testcaseBaseName.getText();
	}

	public IPath getTo()
	{
		return new Path(targetFolderCombo.getText());
	}

	protected Object getOutputFolderName()
	{
		Object response = null;

		IContainer initialContainer = ResourcesPlugin.getWorkspace().getRoot();
		if(targetFolderCombo.getText().length() > 0)
		{
			IPath path = new Path(targetFolderCombo.getText());
			IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
			if((res != null) && (res instanceof IContainer))
				initialContainer = (IContainer)res;
		}

		ContainerSelectionDialog containerSelection = new ContainerSelectionDialog(getShell(), initialContainer, true, TestHttpPlugin.getString("ContainerSelection.Description"));
		containerSelection.showClosedProjects(false);
		
		
		if (containerSelection.open() == ContainerSelectionDialog.OK)
		{
			Object[] result = containerSelection.getResult();
			if (result != null && result.length == 1 && result[0] != null)
				if (result[0] instanceof Path)
					response = result[0];
		}

		return response;
	}
}