/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DatapoolForm extends EditorForm {

	private NamedElementSection namedElementSection;	

	/**
	 * Constructor for DatapoolForm
	 * @param datapoolEditorExtension
	 * @param widgetFactory
	 */
	public DatapoolForm(DatapoolEditorExtension datapoolEditorExtension, WidgetFactory widgetFactory)
	{
		super(datapoolEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DATAPOOL"));
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		namedElementSection.dispose();
		namedElementSection = null;
		

		super.dispose();
	}

	/**
	 * Returns the datapool manipulated by this form.
	 * @return DPLDatapool
	 */
	protected DPLDatapool getDatapool()
	{
		return ((DatapoolEditorExtension)getBaseEditorExtension()).getDatapool();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.DATA_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);

		Control control = createGenericInformation(leftColumn);
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.DATA_NAME_FORM);								
		
	}
	
	/**
	 * Creates the generic information form section.
	 * @return FormSection
	 */
	protected Control createGenericInformation(Composite parent)
	{
		namedElementSection = new NamedElementSection(this)
		{
			private StyledText fileText;
			
			protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
			{
				Composite detailComposite = getWidgetFactory().createComposite(parent);
				GridLayout gridLayout = new GridLayout(2, false);
				gridLayout.marginHeight = 0;
				gridLayout.marginWidth = 0;
				detailComposite.setLayout(gridLayout);
				detailComposite.setLayoutData(GridDataUtil.createHorizontalFill());

				getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
				fileText = getWidgetFactory().createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
				fileText.setEnabled(false);
				fileText.setLayoutData(GridDataUtil.createHorizontalFill());
				WorkbenchHelp.setHelp(fileText, TestUIPlugin.getID() + ContextIds.DATA_TEXT_FORM);								
				
			}
			
			public void setInput(Object object)
			{
				super.setInput(object);
				
				IFile file = EMFUtil.getWorkspaceFile(getDatapool());
				if(file != null)
					fileText.setText(file.getFullPath().toString());						
			}
		};
		registerSection(namedElementSection);		
		namedElementSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
		namedElementSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
		return namedElementSection.createControl(parent, getWidgetFactory());
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		namedElementSection.setInput(getDatapool());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
		String title = ((IWorkbenchAdapter)((IAdaptable)getDatapool()).getAdapter(IWorkbenchAdapter.class)).getLabel(getDatapool());
		if(title != null)
			getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		return true;
	}

}
