/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddLocationAction;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class LocationForm
extends EditorForm implements ISelectionChangedListener
{
	private EObjectTreeSection locationSection;
	private NamedElementSection commonSection;
	private DetailSection detailSection;
	private AddLocationAction addLocationAction;
	private boolean firstActivation = true;
	
	/**
	 * Constructor for LocationForm
	 * @param deploymentEditorExtension
	 * @param widgetFactory
	 */
	public LocationForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory)
	{
		super(deploymentEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT"));
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		locationSection.getTreeViewer().removeSelectionChangedListener(this);
		locationSection.dispose();
		commonSection.dispose();
		detailSection.dispose();
		addLocationAction.dispose();
		
		super.dispose();
	}

	/**
	 * Returns the deployment that is manipulated by this form.
	 * @return TPFDeployment 
	 */
	protected TPFDeployment getDeployment()
	{
		return ((DeploymentEditorExtension)getBaseEditorExtension()).getDeployment();
	}

	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.LOC_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		addLocationAction = new AddLocationAction();
		locationSection = new EObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), addLocationAction);
		registerSection(locationSection);
		locationSection.setHeaderText(TestUIPlugin.getString("W_LOCS"));
		locationSection.setCollapsable(true);
		Control control = locationSection.createControl(leftColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));		
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.LOC_LOC_FORM);								
		WorkbenchHelp.setHelp(locationSection.getTreeViewer().getControl(), TestUIPlugin.getID() + ContextIds.LOC_LOCTREE_FORM);								
		
		commonSection = new NamedElementSection(this);
		commonSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
		commonSection.setHeaderText(TestUIPlugin.getString("TTL_CMN_PROPS"));
		registerSection(commonSection);		
		control = commonSection.createControl(rightColumn, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);		
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.LOC_COMMON_FORM);								

		detailSection = new DetailSection(this);
		addDetails(detailSection);	
		if(!detailSection.isEmpty())
		{
			detailSection.setHeaderText(TestUIPlugin.getString("TTL_DTL_PROPS"));
			registerSection(detailSection);
			control = detailSection.createControl(rightColumn, getWidgetFactory());
			gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
			control.setLayoutData(gridData);
			WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.LOC_DETAIL_FORM);											
		}
	}
	
	protected void addDetails(DetailSection detailSection)
	{
		detailSection.add(CFGMachine.class, new MachineDetailPage());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		addLocationAction.setDeployment(getDeployment());		

		locationSection.getTreeViewer().removeSelectionChangedListener(this);
		locationSection.setInput(getDeployment());
		locationSection.getTreeViewer().addSelectionChangedListener(this);
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		locationSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == locationSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			commonSection.setInput(structuredSelection);
			if(detailSection != null)
				detailSection.setInput(structuredSelection);
		}
	}
	
	public ISelection getSelection()
	{
		return locationSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			locationSection.setFocus();
		}
			
		return super.activated();
	}
}
