/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.part.ISetSelectionTarget;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author marcelop
 * @since 0.3.0
 */
public abstract class EditorSection 
extends FormSection implements IDisposable, VerifyKeyListener, ISetSelectionTarget
{
	private EditorForm editorForm;
	private FormWidgetFactory formWidgetFactory;
	
	/**
	 * Constructor for EMFEditorSection
	 * @param editorForm
	 */
	protected EditorSection(EditorForm editorForm)
	{
		this.editorForm = editorForm;
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		editorForm = null;
		formWidgetFactory = null;
		
		super.dispose();
	}
	
	protected FormWidgetFactory getFormWidgetFactory()
	{
		return formWidgetFactory;		
	}

	protected void setFormWidgetFactory(FormWidgetFactory formWidgetFactory)
	{
		this.formWidgetFactory = formWidgetFactory;		
	}

	/**
	 * Returns this section's editor form.
	 * @return EditorForm
	 */
	protected EditorForm getEditorForm()
	{
		return editorForm;
	}
	
	/**
	 * Utility method to retrieve the Hyades editor part.
	 * @return IHyadesEditorPart
	 */
	protected IHyadesEditorPart getHyadesEditorPart()
	{
		return getEditorForm().getBaseEditorExtension().getHyadesEditorPart();
	}
	
	/**
	 * Utility method to retrieve the clipboard.
	 * @return Clipboard
	 */
	protected Clipboard getClipboard()
	{
		return getEditorForm().getBaseEditorExtension().getClipboard();
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#isReadOnly()
	 */
	public boolean isReadOnly()
	{
		return getHyadesEditorPart().isReadOnly();
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#isDirty()
	 */
	public boolean isDirty()
	{
		return getHyadesEditorPart().isDirty();
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#initialize(java.lang.Object)
	 */
	public void initialize(Object input)
	{
		setInput(input);
	}

	/**
	 * Place holder that customers can invoke to trigger the section's data to
	 * be loaded.
	 * @param object  This section input.
	 */
	abstract public void setInput(Object object);
	
	/**
	 * Returns the section's input.
	 * @return Object
	 */
	abstract public Object getInput();

	/**
	 * Returns this section's selection.
	 * @return IStructuredSelection
	 */
	abstract public IStructuredSelection getStructuredSelection();

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#reflow()
	 */
	protected void reflow()
	{
		super.reflow();
		editorForm.updateScrollBars();
	}

	/**
	 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
	 */
	public void verifyKey(VerifyEvent event)
	{
		event.doit = !getHyadesEditorPart().isReadOnly();
	}
}
