/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

import org.eclipse.hyades.test.ui.internal.editor.form.base.EditableTablePart;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;

/**
 * @author marcelop
 * @since 0.3.0
 */
public abstract class TableSection 
extends StructuredViewerSection
{
	protected class PartAdapter 
	extends EditableTablePart
	{
		public PartAdapter(String[] buttonLabels)
		{
			super(buttonLabels);
		}
		public void entryModified(Object entry, String value)
		{
			TableSection.this.entryModified(entry, value);
		}
		public void selectionChanged(IStructuredSelection selection)
		{
			TableSection.this.selectionChanged(selection);
		}
		public void handleDoubleClick(IStructuredSelection selection)
		{
			TableSection.this.handleDoubleClick(selection);
		}
		public void buttonSelected(Button button, int index)
		{
			TableSection.this.buttonSelected(index);
			if(isHandlingDefaultButton())
				button.getShell().setDefaultButton(null);
		}
	}

	/**
	 * Constructor for BaseTableSection
	 * @param editorForm
	 * @param buttonLabels
	 */
	public TableSection(EditorForm editorForm, String[] buttonLabels)
	{
		super(editorForm, buttonLabels);
	}

	/**
	 * Constructor for BaseTableSection
	 * @param editorForm
	 */
	public TableSection(EditorForm editorForm)
	{
		super(editorForm);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.StructuredViewerSection#createViewerPart(java.lang.String[])
	 */
	protected StructuredViewerPart createViewerPart(String [] buttonLabels)
	{
		EditableTablePart tablePart = new PartAdapter(buttonLabels);
		tablePart.setEditable(!isReadOnly());
		return tablePart;
	}
	
	/**
	 * Returns this section's editable table part.
	 * @return EditableTablePart
	 */
	public EditableTablePart getEditableTablePart()
	{
		return (EditableTablePart)getViewerPart();
	}
	
	/**
	 * Returns this section's tree viewer.
	 * @return TreeViewer
	 */
	public TableViewer getTableViewer()
	{
		return getEditableTablePart().getTableViewer();
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		setFormWidgetFactory(formWidgetFactory);
		Composite container = createClientContainer(parent, 2, getFormWidgetFactory());
		createViewerPartControl(container, SWT.FULL_SELECTION | SWT.MULTI, 2, getFormWidgetFactory());
		
		getTableViewer().getControl().setFocus();

		adjustClient(parent);

		getFormWidgetFactory().paintBordersFor(container);
		return container;
	}
	
	/**
	 * This method helps subclasses to extend the create client method.
	 * @param parent
	 */
	protected void adjustClient(Composite parent)
	{
		
	}
}
