/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.Iterator;
import java.util.ListIterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class MoveChildrenDownAction
extends ChildrenSelectionAction
{
	private EStructuralFeature eStructuralFeature;
	
	/**
	 * Constructor for MoveChildrenDownAction
	 */
	public MoveChildrenDownAction()
	{
		super(TestUIPlugin.getString("LBL_DOWN"));

		setToolTipText(TestUIPlugin.getString("ACT_DOWN_DSC"));
		TestUIImages.INSTANCE.setImageDescriptors(this, TestUIImages.ACT_DOWN);
	}

	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		eStructuralFeature = null;
		super.dispose();
	}
	
	/**
	 * @return
	 */
	public EStructuralFeature getEStructuralFeature()
	{
		return eStructuralFeature;
	}

	/**
	 * @The feature must be not <code>null</code> and a "many" feature. 
	 * @param structuralFeature
	 */
	public void setEStructuralFeature(EStructuralFeature feature)
	{
		eStructuralFeature = null;
		if((feature == null) || (!feature.isMany()))
			return;

		eStructuralFeature = feature;
	}

	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(eStructuralFeature == null)
			return false;

		if(!super.updateSelection(selection))
			return false;
			
		EObject container = ((EObject)getChilren().get(0)).eContainer();
		EList allChildren = null;
		try
		{
			allChildren = (EList)container.eGet(eStructuralFeature);
		}
		catch(RuntimeException re)
		{
			getChilren().clear();
			return false;	
		}

		if(allChildren.size() == 1)
		{
			getChilren().clear();
			return false;
		}
			
		if((getChilren().size() == 1) && (allChildren.get(allChildren.size()-1) == getChilren().get(0)))
		{
			getChilren().clear();
			return false;			
		}
		
		for(Iterator i = getChilren().iterator(); i.hasNext();)
		{
			EObject	child = (EObject)i.next();
			if(child.eContainer() != container)
			{
				getChilren().clear();
				return false;
			}
		}
		
		return true;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		if(eStructuralFeature == null)
			return;
		
		EObject container = ((EObject)getChilren().get(0)).eContainer();
		EList allChildren = (EList)container.eGet(eStructuralFeature);

		int botton = allChildren.size()-1;
		for(ListIterator i=getChilren().listIterator(getChilren().size()); i.hasPrevious(); )
		{
			Object element = i.previous();
			int index = allChildren.indexOf(element);
			if(index < 0)
				continue;

			if(index < botton)
			{
				allChildren.move(index, index+1);
			}
			else
			{
				botton--;
			}
		}

		setActionPerformed(true);
	}
}
