/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NewObjectAction;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

/**
 * Creation group action for the Test Navigator.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class NewActionGroup 
extends NavigatorActionGroup
{
	private NewObjectAction newTestSuiteAction;
	private NewObjectAction newDeploymentAction;
	
	private NewObjectAction newHyadesObjectAction;

	/**
	 * Constructor for CreateGroupAction
	 * @param testNavigator
	 */
	public NewActionGroup(TreeNavigator testNavigator)
	{
		super(testNavigator);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions()
	{
		newTestSuiteAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newTestSuiteAction.setText(TestUIPlugin.getString("LBL_TST_SUITE"));
		newTestSuiteAction.setToolTipText(newTestSuiteAction.getText());
		newTestSuiteAction.setWizardTitle(TestUIPlugin.getString("WIZ_TST_SUITE_TTL"));
		newTestSuiteAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new/testSuite");

		newDeploymentAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newDeploymentAction.setText(TestUIPlugin.getString("LBL_DEPLOYMENT"));
		newDeploymentAction.setToolTipText(newDeploymentAction.getText());
		newDeploymentAction.setWizardTitle(TestUIPlugin.getString("WIZ_DEPLOY_TTL"));
		newDeploymentAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new/testElements");
		
		newHyadesObjectAction = new NewObjectAction(getNavigator().getSite().getWorkbenchWindow());
		newHyadesObjectAction.setText(TestUIPlugin.getString("WIZ_TST_OBJ_ACT"));
		newHyadesObjectAction.setWizardTitle(TestUIPlugin.getString("WIZ_TST_OBJ_TTL"));
		newHyadesObjectAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new");
		newHyadesObjectAction.setToolTipText(newHyadesObjectAction.getText());
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{
		IStructuredSelection structuredSelection = (IStructuredSelection)getContext().getSelection();

        
		if(getNavigator().isShowingFolders())
		{
			if(!hasLogicalFolder(structuredSelection))
			{
				MenuManager newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
				menu.add(newMenu);

				new NewWizardMenu(newMenu, getNavigator().getSite().getWorkbenchWindow(), false);

				newMenu.insert(0, new ActionContributionItem(newHyadesObjectAction));
				newMenu.insert(1, new Separator());
			}
		}
		else
		{
			if(structuredSelection.size() == 1)
			{
				Object selection = structuredSelection.getFirstElement();
				if(selection instanceof LogicalFolder)
				{
					LogicalFolder logicalFolder = (LogicalFolder)selection;
					if(logicalFolder.getParent() == null)
					{
						MenuManager newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
						menu.add(newMenu);

						String name = logicalFolder.getName();
						if(TestWorkbenchAdapter.TEST_SUITE_LOGICAL_FOLDER_NAME.equals(name))
							newMenu.add(newTestSuiteAction);

						else if(TestWorkbenchAdapter.DEPLOYMENT_LOGICAL_FOLDER_NAME.equals(name))
							newMenu.add(newDeploymentAction);
					}
				}
			}
		}
	}
	
	/**
	 * Returns <code>true</code> is there is one logical folder in the 
	 * given selection.
	 * @param structuredSelection
	 * @return boolean
	 */
	protected boolean hasLogicalFolder(IStructuredSelection structuredSelection)
	{
		for (Iterator i = structuredSelection.iterator(); i.hasNext();)
		{
			if(i.next() instanceof LogicalFolder)
				return true;
		}
		
		return false;
	}
}
