/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.hyades.ui.internal.util.UIUtil;

/**
 * Open file editor action.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public class OpenEditorAction 
extends NavigatorAction
{
	private static final String HYADES_EDITOR_ID_PREFIX = "org.eclipse.hyades.";
	
	private IFile fileToOpen;
	
	/**
	 * Constructor for OpenAction
	 * @param navigator
	 * @param label
	 */
	public OpenEditorAction(TestNavigator testNavigator, String label)
	{
		super(testNavigator, label);
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.OPEN_EDITOR_ACT);												
	}
	
	/**
	 * @see org.eclipse.ui.actions.SelectionProviderAction#dispose()
	 */
	public void dispose()
	{
		fileToOpen = null;
		super.dispose();
	}	

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		UIUtil.openEditor(fileToOpen, HYADES_EDITOR_ID_PREFIX, true);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction#isApplicableForSelection()
	 */
	public boolean isApplicableForSelection()
	{
		return (fileToOpen != null);
	}
	
	/**
	 * @see org.eclipse.ui.actions.SelectionProviderAction#selectionChanged(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void selectionChanged(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() == 1)
			fileToOpen = ((TestNavigator)getNavigator()).getFile(structuredSelection.getFirstElement());
		else
			fileToOpen = null;
	}	
}
