/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class SDPluginImages {
	
	private static URL fgIconBaseURL = null;

	static {
		String pathSuffix = "icons/full/"; //$NON-NLS-1$
		try {
			fgIconBaseURL =
				new URL(SDPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
		} catch (MalformedURLException e) {
		}
	}

	/*
	 * Set of predefined Image Descriptors.
	 * the following Strings are all $NON-NLS-1$
	 */
	public static final String T_LCL = "lcl16"; //$NON-NLS-1$
	public static final String T_TOOL = "tool16"; //$NON-NLS-1$
	public static final String T_VIEW = "view16"; //$NON-NLS-1$
	public static final String T_CVIEW = "cview16"; //$NON-NLS-1$
	public static final String T_OBJ = "obj16"; //$NON-NLS-1$
	public static final String T_WIZBAN = "wizban"; //$NON-NLS-1$
	
	public static final String IMG_IDATRACE	= "sequencediagram_view.gif";
	public static final String IMG_REFRESH 	= "refresh_nav.gif";
	public static final String IMG_REFRESH_VIEWS = "updateviews_co.gif";
	public static final String IMG_ZOOM_IN 	= "zoomin_nav.gif";
	public static final String IMG_ZOOM_OUT 	= "zoomout_nav.gif";
	public static final String IMG_HOME 		= "home_nav.gif";
	public static final String IMG_MONITOR 	= "monitor_obj.gif";
	public static final String IMG_NODE 		= "node_obj.gif";
	public static final String IMG_PROCESS 	= "process_obj.gif";
	public static final String IMG_AGENT      = "agent_run_obj.gif";
	public static final String IMG_THREAD 	= "thread_obj.gif";
	public static final String IMG_CLASS 	= "class.gif";
	public static final String IMG_OBJECT 	= "classobject_obj.gif";
	public static final String IMG_METHOD 	= "method.gif";
	public static final String IMG_LOG 		= "log_obj.gif";
	public static final String IMG_RECORD 	= "record_obj.gif";
	public static final String IMG_SEARCH     = "search_seqdiag_co.gif";
	public static final String IMG_CLASS_SEARCH = "searchclass_obj.gif";
	public static final String IMG_OBJECT_SEARCH = "searchobject_obj.gif";
	public static final String IMG_HOST_SEARCH = "searchhost_obj.gif";
	public static final String IMG_THREAD_SEARCH = "searchthread_obj.gif";
	public static final String IMG_PROCESS_SEARCH = "searchprocess_obj.gif";
	public static final String IMG_AGENT_SEARCH = "searchagent_obj.gif";
	public static final String IMG_LOG_SEARCH = "searchlog_obj.gif";
	public static final String IMG_RECORD_SEARCH = "searchrecord_obj.gif";

    public static final ImageDescriptor DESC_IMG_IDATRACE = createManaged(T_CVIEW,IMG_IDATRACE);
    
    public static final ImageDescriptor DESC_IMG_MONITOR	= createManaged(T_OBJ,IMG_MONITOR);
    public static final ImageDescriptor DESC_IMG_NODE 	= createManaged(T_OBJ,IMG_NODE);
    public static final ImageDescriptor DESC_IMG_PROCESS	= createManaged(T_OBJ,IMG_PROCESS);
    public static final ImageDescriptor DESC_IMG_AGENT 	= createManaged(T_OBJ,IMG_AGENT);
    public static final ImageDescriptor DESC_IMG_THREAD 	= createManaged(T_OBJ,IMG_THREAD);
    public static final ImageDescriptor DESC_IMG_CLASS 	= createManaged(T_OBJ,IMG_CLASS);
    public static final ImageDescriptor DESC_IMG_OBJECT 	= createManaged(T_OBJ,IMG_OBJECT);
    public static final ImageDescriptor DESC_IMG_METHOD 	= createManaged(T_OBJ,IMG_METHOD);
    public static final ImageDescriptor DESC_IMG_LOG 	= createManaged(T_OBJ,IMG_LOG);
    public static final ImageDescriptor DESC_IMG_RECORD 	= createManaged(T_OBJ,IMG_RECORD);
    
    public static final ImageDescriptor DESC_IMG_CLASS_SEARCH 	= createManaged(T_OBJ,IMG_CLASS_SEARCH);
	public static final ImageDescriptor DESC_IMG_OBJECT_SEARCH 	= createManaged(T_OBJ,IMG_OBJECT_SEARCH);
	public static final ImageDescriptor DESC_IMG_HOST_SEARCH 	= createManaged(T_OBJ,IMG_HOST_SEARCH);
	public static final ImageDescriptor DESC_IMG_THREAD_SEARCH 	= createManaged(T_OBJ,IMG_THREAD_SEARCH);
	public static final ImageDescriptor DESC_IMG_PROCESS_SEARCH 	= createManaged(T_OBJ,IMG_PROCESS_SEARCH);
	public static final ImageDescriptor DESC_IMG_AGENT_SEARCH 	= createManaged(T_OBJ,IMG_AGENT_SEARCH);
	public static final ImageDescriptor DESC_IMG_LOG_SEARCH 		= createManaged(T_OBJ,IMG_LOG_SEARCH);
	public static final ImageDescriptor DESC_IMG_RECORD_SEARCH 	= createManaged(T_OBJ,IMG_RECORD_SEARCH);
		
	protected static Hashtable _images;
	protected static Hashtable _imageDescriptors;

	public static Image getImage(String name)
	{
		return (Image)_images.get(name);
	}

	public static ImageDescriptor getImageDescriptor(String name) {
		return (ImageDescriptor) _imageDescriptors.get(name);
	}

	private static ImageDescriptor createManaged(String prefix, String name) {
		try {
			ImageDescriptor result =
				ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));

			if (_images == null || _imageDescriptors == null) {
				_images = new Hashtable();
				_imageDescriptors = new Hashtable();
			}

			_imageDescriptors.put(name, result);
			_images.put(name, result.createImage());
			return result;

		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	public static void setImageDescriptors(
		IAction action,
		String type,
		String relPath) {
		try {
			ImageDescriptor id =
				ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath));//$NON-NLS-1$
			if (id != null) {
				action.setDisabledImageDescriptor(id);
			}
		} catch (MalformedURLException e) {
		}

		try {
			ImageDescriptor id =
				ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath));//$NON-NLS-1$
			if (id != null) {
				action.setHoverImageDescriptor(id);
			}
		} catch (MalformedURLException e) {
		}

		action.setImageDescriptor(create("e" + type, relPath));//$NON-NLS-1$
	}

	private static URL makeIconFileURL(String prefix, String name)
		throws MalformedURLException {
		if (fgIconBaseURL == null)
			throw new MalformedURLException();

		StringBuffer buffer;
		if (prefix != null) {
			buffer = new StringBuffer(prefix);
			buffer.append('/');
			buffer.append(name);
		} else {
			buffer = new StringBuffer(name);
		}
		return new URL(fgIconBaseURL, buffer.toString());
	}

	private static ImageDescriptor create(String prefix, String name) {
		try {
			return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	public static void shutdown() {
		if (_images == null)
			return;

		for (Iterator e = _images.values().iterator(); e.hasNext();) {
			Object next = e.next();
			if (next instanceof Image && !((Image) next).isDisposed()) {
				((Image) next).dispose();
			}
		}

		_images.clear();
		_images = null;
		_imageDescriptors.clear();
		_imageDescriptors = null;

	}

}
