/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

import java.util.Map;

import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.swt.graphics.GC;

public class ColumnNode implements GraphNode {

	private int nodePosition = 0;
	private int startPosition =0, stopPosition =0;
	private int beginPosition, endPosition;
	private int xOffset = 0;
	private boolean selected = false;
	private boolean positionSet = false;
	
	/**
	 * Constructor for ColumnNode
	 */
	public ColumnNode(){}

	public GraphNode getGraphNode(){
		return this;
	}
		
	public void init(){
		startPosition = getStartIncrementValue();
		stopPosition = getEndIncrementValue();
	}

	public void setPosition(int pos) {
		positionSet = true;
		nodePosition = pos;
	}
	public int getPosition() {
		return nodePosition;
	}
	
	public int getStartPosition() {
		return startPosition;
	}
	public int getStopPosition() {
		return stopPosition;
	}
	
	public int getPositionRange(){
	   return endPosition - beginPosition;	
	}
	
	public int getBeginPosition(){
	   return beginPosition;	
	}
	public int getEndPosition(){
	   return endPosition;	
	}
	
	public void setSelected(boolean state){
	   selected = state;	
	}

	public boolean isPositionSet() {
		return positionSet;
	}
	
	public void disposeMe(){	
	}

	public void drawSelf(GC gc, int width, int timeUnit, int boxSpace, int startDrawingPosition, int bottomMax, int nodeWidth, int xOffset, Map columnPassagesMap) {

		if(selected)
		   gc.setForeground(LogCDrawUtils.getForegroundSelectedColor());
		else
		   gc.setForeground(LogCDrawUtils.getForegroundColor());
		   
		//calculate the y coordinate for drawing, in pixel. 
		beginPosition = (startPosition - startDrawingPosition)* timeUnit + boxSpace;
		endPosition = (stopPosition - startDrawingPosition) * timeUnit + boxSpace;

		if(userArea != null && userArea instanceof CBECommonBaseEvent)
		{			
	   	      short sev = ((CBECommonBaseEvent)userArea).getSeverity();
	   	      
	   	      if(sev >=0 && sev <=70)
	   	      {
	   	      	 if(sev >=50)
	   	      	 {
			         gc.setBackground(LogCDrawUtils.getRedEventFillColor());
			         gc.setForeground(LogCDrawUtils.getRedEventStrokeColor());			          	   	      	 				          
	   	      	 }
	   	      	 else if(sev >=30 && sev < 50)
	   	      	 {
			          gc.setBackground(LogCDrawUtils.getYellowEventFillColor());
			          gc.setForeground(LogCDrawUtils.getYellowEventStrokeColor());			          	   	      	 				          
	   	      	 }
	   	      	 else if(sev< 30)		   	      	 
	   	      	 {   	
			          gc.setBackground(LogCDrawUtils.getBlueEventFillColor());
			          gc.setForeground(LogCDrawUtils.getBlueEventStrokeColor());			          	   	      	 				          
	   	      	 }
	   	      }	
		}

		int[] corners =
			{
				xOffset+width / 2 - 5,   //top left X
				beginPosition,           //top left Y
				xOffset+width / 2 + 5,   //top right X
				beginPosition,           //top right Y
				xOffset+width / 2 + 5,   //bottom right X
				endPosition,             //bottom right Y
				xOffset+width / 2 - 5,   //bottom left X
				endPosition };           //bottom right Y
				
		gc.fillPolygon(corners);
		gc.drawPolygon(corners);		
		
		if(userArea != null && userArea instanceof CBECommonBaseEvent)
		{
			if(selected)
			{
				gc.setForeground(LogCDrawUtils.getLogHighLightColor());		          		          			          	   	      	 				          	   	      	   	      

				int[] selectedCorners = 
				{
					xOffset+width / 2 - 6,   //top left X
					beginPosition-1,           //top left Y
					xOffset+width / 2 + 6,   //top right X
					beginPosition-1,           //top right Y
					xOffset+width / 2 + 6,   //bottom right X
					endPosition+1,             //bottom right Y
					xOffset+width / 2 - 6,   //bottom left X
					endPosition+1 };           //bottom right Y
				
				gc.drawPolygon(selectedCorners);
			}
		}
					
        gc.setBackground(LogCDrawUtils.getBackgroundColor());
        

           
		NodeLink nodeConnection;
		int position;
		for (int i = 0; i < sourceConnections.length; i++) {
			if(sourceConnections[i]!=null){
			   nodeConnection = (NodeLink) sourceConnections[i];
				// calculate the y coordinate for drawing, in pixel.
			   position = (nodeConnection.getStartIncrementValue() - startDrawingPosition)*timeUnit + boxSpace;
			   if (position >= 0 && position <= bottomMax)
				  nodeConnection.drawSelf(gc, width, this, timeUnit, boxSpace, startDrawingPosition, nodeWidth, xOffset,columnPassagesMap);
				 
			   if (position > bottomMax)
			   {
				   position = (nodeConnection.getSource().getStartIncrementValue() - startDrawingPosition)*timeUnit + boxSpace;
				   if ( position >= 0 && position <= bottomMax)
				   {
					  nodeConnection.drawSelf(gc, width, this, timeUnit, boxSpace, startDrawingPosition, nodeWidth, xOffset,columnPassagesMap);
				   }
			   }
			}
		}
		for (int i = 0; i < targetConnections.length; i++) {
			if(targetConnections[i]!=null){
			   nodeConnection = (NodeLink) targetConnections[i];
			   // calculate the y coordinate for drawing, in pixel.
			   position = (nodeConnection.getStartIncrementValue() - startDrawingPosition)*timeUnit + boxSpace;
			   if (position >= 0 && position <= bottomMax)
				  nodeConnection.drawSelf(gc, width, this, timeUnit, boxSpace, startDrawingPosition, nodeWidth, xOffset,columnPassagesMap);
			}
		}			
	}
		
  //implement GraphNode -> begin
  public String name=null;
  public int type = 0; // The node type is an enumerated vaule yet to be defined. It could be used to control how the object is rendered.
  public double startTime = 0;
  public double endTime = 0;
  public Increment startIncrement = null;
  public Increment endIncrement = null;
  public int nextNewSourceConnection = 0;
  public int nextNewTargetConnection = 0;
  public int indexInContainer = 0;
  public String shortName = null;
  public String secondaryName = null;
  public Object userArea = null;
  public Graph graph = null;
  public NodeContainer container = null;
  public NodeConnection lastReadTargetConnection = null;
  public NodeConnection targetConnections[] = new NodeConnection[3];
  public NodeConnection sourceConnections[] = new NodeConnection[3];
	
  public String getName() {
    return name;
  }
  public void setName(String inputName) {
	name = inputName;
  }
  
  public String getShortName() {
    return shortName;
  }
  public void setShortName(String name) {
    shortName = name;
  }

  public String getSecondaryName() {
    return secondaryName;
  }
  public void setSecondaryName(String name) {
    secondaryName = name;
  }

  public int getType() {
    return type;
  }
  public void setType(int inputType) {
    type = inputType;
  }

  public Graph getGraph() {
	if (graph == null)
	  graph = getContainer().getGraph();
	return graph;
  }
  public void setGraph(Graph inputGraph) {
	graph = inputGraph;
  }

  public NodeContainer getContainer() {
	return container;
  }
  public void setContainer(NodeContainer inputContainer) {
	container = inputContainer;
  }

  public double getStartTime() {
    return startTime;
  }
  public void setStartTime(double time) {
    startTime = time;
    startIncrement = getGraph().addIncrementAppendDup(time);
  }

  public Increment getStartIncrement() {
	return startIncrement;
  }  
  public void setStartIncrement(Increment increment) {
    startTime = increment.getTime();
    startIncrement = increment;
  }

  public double getEndTime() {
    return endTime;
  }
  public void setEndTime(double time) {
    endTime = time;
    endIncrement = getGraph().addIncrementAppendDup(time);    
  }

  public Increment getEndIncrement() {
	return endIncrement;
  }  
  public void setEndIncrement(Increment increment) {
    endTime = increment.getTime();
    endIncrement = increment;
  }

  public int getStartIncrementValue() {
    if (startIncrement != null)
      return startIncrement.getValue();
    else
      return 0;
  }
  public int getEndIncrementValue()
  {
    if (endIncrement != null)
      return endIncrement.getValue();
    else
      return 0;
  }

  public void addSourceConnection(NodeConnection connection)  {
	try {
	  sourceConnections[nextNewSourceConnection] = connection;
	}
	catch (ArrayIndexOutOfBoundsException e) {
	  NodeConnection[] tempArray = new NodeConnection[2 * sourceConnections.length];
	  System.arraycopy(sourceConnections, 0, tempArray, 0, sourceConnections.length);
	  sourceConnections = tempArray;
	  sourceConnections[nextNewSourceConnection] = connection;
	}
	// if the new connection end increment is not between the node start and end
	// fix it
	if (connection.getEndIncrement().getValue() < getStartIncrement().getValue())
	  graph.moveIncrementAndAdjust(
		getStartIncrement(),
		connection.getStartIncrement().getValue());
	if (connection.getEndIncrement().getValue() > getEndIncrement().getValue())
	  graph.moveIncrementAndAdjust(
		connection.getEndIncrement(),
		getEndIncrement().getValue());

	nextNewSourceConnection++;
  }

  public void addTargetConnection(NodeConnection connection) {
	try
	{
	  targetConnections[nextNewTargetConnection] = connection;
	}
	catch (ArrayIndexOutOfBoundsException e)
	{
	  NodeConnection[] tempArray = new NodeConnection[2 * targetConnections.length];
	  System.arraycopy(targetConnections, 0, tempArray, 0, targetConnections.length);
	  targetConnections = tempArray;
	  targetConnections[nextNewTargetConnection] = connection;
	}
	// if the new connection start increment is is not between the node start and end
	// fix it
	if (connection.getStartIncrement().getValue() < getStartIncrement().getValue())
	  graph.moveIncrementAndAdjust(
		getStartIncrement(),
		connection.getStartIncrement().getValue());
	if (connection.getStartIncrement().getValue() > getEndIncrement().getValue())
	  graph.moveIncrementAndAdjust(
		connection.getEndIncrement(),
		getEndIncrement().getValue());

	nextNewTargetConnection++;
  }


  public NodeConnection[] getSourceConnections() {
    return sourceConnections;
  }
  public void setSourceConnections(NodeConnection[] connections) {
    sourceConnections = connections;
  }

  public NodeConnection[] getTargetConnections(){
    return targetConnections;
  }
  public void setTargetConnections(NodeConnection[] connections) {
    targetConnections = connections;
  }

  public int getSourceConnectionCount() {
    return nextNewSourceConnection;
  }
  public int getTargetConnectionCount() {
    return nextNewTargetConnection;
  }
  
  public NodeConnection getLastReadTargetConnection() {
	return lastReadTargetConnection;
  }
  public void setLastReadTargetConnection(NodeConnection connection) {
	lastReadTargetConnection = connection;
  }
  
  public void setUserArea(Object area) {
    userArea = area;
  }
  public Object getUserArea() {
    return userArea;
  }

  public int getIndexInContainer() {
    return indexInContainer;
  }
  public void setIndexInContainer(int index) {
    indexInContainer = index;
  }
	
  public int getXOffset() {
	return xOffset;
  }
  public void setXOffset(int xOffset) {
	this.xOffset = xOffset;
  }
  //implement GraphNode -> end
  
}
