/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

public class MethodConnection implements NodeConnection {

	/**
	 * Constructor for MethodConnection.
	 */
	public MethodConnection() {
		super();
	}
	
	//NodeConnection implementation ->begin
    private String name = null;
    private String shortName = null;
    private String secondaryName = null;
    
    private int type = 0;
    private double startTime = 0;
    private double endTime = 0;
    private Increment startIncrement = null;
    private Increment endIncrement = null;
    
    private Object userArea = null;
    private GraphNode source;
    private GraphNode target;
    private boolean selected = false;
    
    /**
   * @return String
   * @since November 23, 2001
   * @roseuid 3BFEC43F0054
   */
  public String getName()
  {
    return name;
  }

  /**
   * @param inputName
   * @since November 23, 2001
   * @roseuid 3BFEC4440173
   */
  public void setName(String inputName)
  {
    name = inputName;
  }
  /**
    * @return String
    * @since December 17, 2001
    */
  public String getShortName()
  {
    return shortName;
  }
  public void setShortName(String name)
  {
    shortName = name;
  }
  /**
  * @return String
  * @since December 17, 2001
  */
  public String getSecondaryName()
  {
    return secondaryName;
  }
  public void setSecondaryName(String name)
  {
    secondaryName = name;
  }

  /**
   * @return int
   * @since November 23, 2001
   * @roseuid 3BFEC44903DD
   */
  public int getType()
  {
    return type;
  }

  /**
   * @param inputType
   * @since November 23, 2001
   * @roseuid 3BFEC44F01AB
   */
  public void setType(int inputType)
  {
    type = inputType;
  }

  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEC4550178
   */
  public double getStartTime()
  {
    return startTime;
  }

  /**
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEC45C004B
   */
  public void setStartTime(double time)
  {
    startTime = time;
    startIncrement = getSource().getGraph().addIncrementAppendDup(time);
  }

  public void setStartIncrement(Increment increment)
  {
    startTime = increment.getTime();
    startIncrement = increment;
  }
  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEC4610279
   */
  public double getEndTime()
  {
    return endTime;
  }

  /**
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEC4670368
   */
  public void setEndTime(double time)
  {
    endTime = time;
    endIncrement = getSource().getGraph().addIncrementAppendDup(time);
  }
  public void setEndIncrement(Increment increment)
  {
    endTime = increment.getTime();
    endIncrement = increment;
  }
  /**
  * @return long
  * @since December 13, 2001
  * 
  */
  public Increment getStartIncrement()
  {

    return startIncrement;

  }

  public int getStartIncrementValue()
  {
    // return new Double(startTime / getSource().getGraph().getSmallestTimeIncrement()).intValue();
    if (startIncrement != null)
      return startIncrement.getValue();
    else
      return 0;

  }
  /**
   * @return int
   * @since December 13, 2001
   * 
   */
  public Increment getEndIncrement()
  {

    return endIncrement;

  }

  public int getEndIncrementValue()
  {
    //return new Double(endTime / getSource().getGraph().getSmallestTimeIncrement()).intValue();
    if (endIncrement != null)
      return endIncrement.getValue();
    else
      return 0;

  }

  /**
   * @return com.ibm.etools.pd.sd.model.GraphNode
   * @since November 23, 2001
   * @roseuid 3BFEC46E01A6
   */
  public GraphNode getSource()
  {
    return source;
  }

  /**
   * @param node
   * @since November 23, 2001
   * @roseuid 3BFEC47401C2
   */
  public void setSource(GraphNode node)
  {
    source = node;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.GraphNode
   * @since November 23, 2001
   * @roseuid 3BFEC47B006E
   */
  public GraphNode getTarget()
  {
    return target;
  }

  /**
   * @param node
   * @since November 23, 2001
   * @roseuid 3BFEC480035A
   */
  public void setTarget(GraphNode node)
  {
    target = node;
  }

  /**
   * @return Object
   * @since November 23, 2001
   * @roseuid 3BFED9700036
   */
  public Object getUserArea()
  {
    return userArea;
  }

  /**
   * @param area
   * @since November 23, 2001
   * @roseuid 3BFED97F01FA
   */
  public void setUserArea(Object area)
  {
    userArea = area;
  }
  
  public void setSelected(boolean state){
	   selected = state;	
	}
	
  public boolean isSelected(){
     return selected;	
  }

}
