/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.util;

import java.text.*;

import org.eclipse.hyades.sd.ui.internal.model.*;
import org.eclipse.hyades.sd.ui.internal.views.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

public class DrawAreaWeightScale extends Canvas implements PaintListener, MouseListener, MouseMoveListener, MouseTrackListener {
 
    Increment[] increments=null;
    GC gc;
    Composite parent;
    private static NumberFormat _decimalFormat = null;
    private static NumberFormat _decimalFormatCompact = null;
    int[] divisions = new int[7];
	/**
	 * Constructor for DrawAreaWeightScale.
	 * @param parent
	 * @param style
	 */
	public DrawAreaWeightScale(Composite p, int style) {
		super(p, SWT.NO_FOCUS|SWT.BORDER);
		LogCDrawUtils.setWeightSelection(-1,null);
		parent = p;
		gc = new GC(this);
		addPaintListener(this);
		addMouseListener(this);
		addMouseMoveListener(this);
		addMouseTrackListener(this);
		
		this.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent e) {
				if (gc!=null) gc.dispose();
				gc=null;
			}
		});   
	}
	
	public void setWeights(Increment[] incr){
		increments = incr;
		calculateDivisions();
	}
	
	public void paintControl(PaintEvent e){
		drawSelf();
	}
	
	public void drawSelf(){
		if(increments==null || increments.length==0) return;
		int boxSpace = LogCDrawUtils.getBoxSpace();
		int startPosition = LogCDrawUtils.getStartPosition();
		int timeUnit = LogCDrawUtils.getTimeUnit();
		int width = LogCDrawUtils.getWeightScaleWidth();
		gc.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		gc.fillRectangle(0,0,width,getSize().y);
		int weight,k=0, divisionNumber=0;
		while(k<=(getSize().y-16)/timeUnit 
				&& startPosition+k+1<increments.length 
				&& increments[startPosition+k+1]!=null) {
		   weight = increments[startPosition+k+1].getWeight();
		   divisionNumber = getDivision(weight);
		   if(weight<=0) weight = 0;
		   Color bgColor = new Color(null,255,255-(divisionNumber*32),255-(divisionNumber*32));
		   gc.setBackground(bgColor);
		   bgColor.dispose();
		   gc.fillRectangle(0,boxSpace+k*timeUnit-1,width,timeUnit);	
		   k++;
		}
	}
	
	private int getDivision(int weight){
		
	   if(weight==0)
		   return 0;
	   int divisionNumber = 0;
	   for(int i=0; i<7; i++){
	   	   if(weight>divisions[i])
	   	      divisionNumber = i;
	   }
	   return divisionNumber+1;	
	}
	
	//This method moves the average weight value into the middle of the 0-255 interval
	private void calculateDivisions(){
		int weightSum=0, k=0;
		while(increments[k]!=null){
		   weightSum += increments[k].getWeight();
		   k++;
		}
            if(k==0)
		   return;
	   	divisions[3]=weightSum/k;
	   	divisions[1]=divisions[3]/2;
	   	divisions[0]=divisions[1]/2;
	   	divisions[2]=divisions[0]+divisions[1];
	   	divisions[5]=(255-divisions[3])/2;
	   	divisions[4]=(divisions[5]-divisions[3])/2;
	   	divisions[6]=divisions[5]+(255-divisions[5])/2;  	
	}
	
	//Mouse Listener
	public void mouseDoubleClick(MouseEvent e){
	   LogCDrawUtils.setWeightSelection(-1,null);
	   ((SDViewerUI)parent).updateUI();
	   int boxSpace = LogCDrawUtils.getBoxSpace();
	   int timeUnit = LogCDrawUtils.getTimeUnit();
	   int startPosition = LogCDrawUtils.getStartPosition();
	   int selectedWeightIndex=(e.y-boxSpace)/timeUnit;
	   int weight = increments[startPosition+selectedWeightIndex+1].getWeight();
	   int divisionNumber = getDivision(weight);
	   LogCDrawUtils.setWeightSelection(startPosition+selectedWeightIndex,new Color(null,255,255-(divisionNumber*32),255-(divisionNumber*32)));
	    ((SDViewerUI)parent).updateUI();
	}
	public void mouseDown(MouseEvent e){}
	public void mouseUp(MouseEvent e){}
	
	//Mouse Listener end
	
	//MouseMoveListener -> begin
	public void mouseMove(MouseEvent e){
		if(increments==null) return;
		int boxSpace = LogCDrawUtils.getBoxSpace();
		if(e.y<boxSpace){
			((SDViewerUI)parent).removeToolTip();
			return;
		}
		int index = (e.y+1-boxSpace)/LogCDrawUtils.getTimeUnit();
		if(index < 0 || index >= increments.length) {
			((SDViewerUI)parent).removeToolTip();
			return;
		}
		//double value = 0;
		Increment increment = increments[LogCDrawUtils.getStartPosition()+index+1];
		if(increment == null){
			((SDViewerUI)parent).removeToolTip();
			return;
		}
		//value = increment.getDeltaTime();
		/*if(value == 0) {
			((SDEditorUI)parent).removeToolTip();
			return;
		}*/
		((SDViewerUI)parent).setToolTip(e.x,e.y,formatTimeValue(increment.getDeltaTime(),false));//String.valueOf(value)+" ");

	}
	//MouseMoveListener ->end
	
	//MouseTrackListener -> begin
	
	public void mouseEnter(MouseEvent e){}
	
	public void mouseExit(MouseEvent e){
	
	   ((SDViewerUI)parent).removeToolTip();
	}
	
	public void mouseHover(MouseEvent e){}
	
    //MouseTrackListener -> end
    
    public static String formatTimeValue(double d, boolean compact) {
	  if (_decimalFormat == null) {
	  	_decimalFormat = NumberFormat.getNumberInstance();
		_decimalFormat.setMaximumIntegerDigits(6);
		_decimalFormat.setMaximumFractionDigits(12);
		_decimalFormat.setMinimumFractionDigits(12);		
		_decimalFormatCompact = NumberFormat.getNumberInstance();
		_decimalFormatCompact.setMaximumIntegerDigits(6);
		_decimalFormatCompact.setMaximumFractionDigits(12);
	  }
	 //return compact ? _decimalFormatCompact.format(d/1000000): _decimalFormat.format(d/1000000);
	 return compact ? _decimalFormatCompact.format(d): _decimalFormat.format(d);
	}

}
