/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.recorder.local;

import java.io.IOException;


/**
 * Thsi interface is implemented by an object which will handle data passed across
 * the RAC data channel from a RecorderAgent.  This object should be instantiated
 * and added to the Recorder Object
 * for Example:
 * 	new Recorder("org.eclipse.hyades.execution.recorder.http",
 * 				new HttpRecorderDataProcessor(),
 * 				new HttpRecorderAgentEnvironmentAdapter(),
 * 				new HttpRecorderExecutableObjectAdapter());
 * 
 * @see org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent
 * @see org.eclipse.hyades.internal.execution.recorder.Recorder
 * @author Ernest Jessee
 */
public interface IRecorderDataProcessor
{
	/**
	 * called to initialize the data processor. This api will be called. 
	 * before any data is sent to the object.
	 */
	public void initialize() throws IOException;
	
	/**
	 * called with data sent across the RAC from the RecorderAgent
	 */
	public void processData(byte[] data);
	
	/**
	 * called with a debug String sent across the RAC from the RecorderAgent
	 */
	public void processDebugString(String debugString);
	
	/**
	 * called with a control String sent across the RAC from the RecorderAgent
	 */
	public void processControlString(String controlString);
	
}
