/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.internal.execution.recorder.ui.views;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility.RecorderHarnessUIException;
import org.eclipse.hyades.internal.execution.recorder.ui.actions.StopRecordingAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

/**
 * Recorder Control View for receiving feedback and controlling recorders during recording
 * @author Ernest Jessee
 */
public class RecorderControlView extends ViewPart 
{
	/**
	 * kbytes received text box
	 */
	private Text kBytesReceived;

	/**
	 * toolbar for buttons
	 */
	private ToolBar toolbar;

	/**
	 * list for feedback items
	 */
	private List statusList;
	
	/**
	 * the default instance
	 */
	public static RecorderControlView instance=null;
	
		
	/**
	 * the view's ID
	 */
	public static final String ID = "org.eclipse.hyades.execution.recorder.ui.views.RecorderControlView"; //$NON-NLS-1$

	

	/**
	 * @see ViewPart#createPartControl
	 */
	public void createPartControl(Composite grandParent)  
	{
		int fontHeight = new GC(grandParent).getFontMetrics().getHeight();
		Composite parent = new Composite(grandParent,SWT.NULL);
		WorkbenchHelp.setHelp(parent,"org.eclipse.hyades.execution.recorder.RecorderControlView"); //$NON-NLS-1$
		RecorderUIUtility.assignFormLayout(parent);
		Canvas bytesReceivedCanvas = new Canvas(parent,SWT.NULL);
		RecorderUIUtility.assignGridLayout(bytesReceivedCanvas,6, true);
		Label bytesReceivedLabel = RecorderUIUtility.createLabel(bytesReceivedCanvas,RecorderPlugin.getResourceString("RecorderControlView.KBYTES_RECEIVED_CONTROL_LABEL"),null); //$NON-NLS-1$
		kBytesReceived = new Text(bytesReceivedCanvas,SWT.READ_ONLY|SWT.BORDER);
	 	Canvas statusCanvas = new Canvas(parent,SWT.NULL);
	 	RecorderUIUtility.assignFormLayout(statusCanvas);
		statusList = new List(statusCanvas,SWT.V_SCROLL|SWT.READ_ONLY|SWT.BORDER);
		try
		{
			RecorderUIUtility.layoutCompositelInFormLayout(bytesReceivedCanvas,0,fontHeight*2,0,100,0,0,0,0);
			RecorderUIUtility.layoutControlInGrid(bytesReceivedLabel,1,GridData.HORIZONTAL_ALIGN_END|GridData.VERTICAL_ALIGN_CENTER);
			RecorderUIUtility.layoutControlInGrid(kBytesReceived,1,GridData.HORIZONTAL_ALIGN_FILL|GridData.VERTICAL_ALIGN_CENTER);
			RecorderUIUtility.layoutControlInFormLayout(statusCanvas,fontHeight*2+5,0,0,0);
			RecorderUIUtility.layoutControlInFormLayout(statusList,0,0,0,0);
		}
		catch (RecorderHarnessUIException e)
		{
			e.printStackTrace();
		}
	 		
		ToolBarManager toolbarManager = (ToolBarManager)getViewSite().getActionBars().getToolBarManager();
		toolbarManager.add(new StopRecordingAction());
				
		
	}

	/**
	 * method for acquiring the active IWorkbenchWindow 
	 * @return IWorkbenchWindow
	 */
	public static IWorkbenchWindow getActiveWorkbenchWindow() 
	{
		return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
	}
	
	/**
	 * returns the active IWorkbenchPage
	 * @return IWorkbenchPage
	 */
	public static IWorkbenchPage getActivePage() 
	{
			IWorkbenchPage page = getActiveWorkbenchWindow().getActivePage();

			if (page == null || !page.getPerspective().getId().equals("org.eclipse.hyades.ui.perspective.TestPerspective"))  //$NON-NLS-1$
			{
				final IWorkbenchWindow dwindow = getActiveWorkbenchWindow();
				page = null;

				try 
				{
					IWorkbenchPage[] persps = dwindow.getPages();
					for (int i = 0; i < persps.length; i++) 
					{
						if (persps[i].getPerspective().getId().equals("org.eclipse.hyades.ui.perspective.TestPerspective"))  //$NON-NLS-1$
						{
							//test perspective						
							page = persps[i];
							dwindow.setActivePage(page);
							break;
						}
					}

					if (page == null) 
					{
						IAdaptable element =ResourcesPlugin.getWorkspace().getRoot();
						IWorkbench workBench = dwindow.getWorkbench();
						if (workBench != null && element != null)
							page =workBench.showPerspective("org.eclipse.hyades.ui.perspective.TestPerspective",getActiveWorkbenchWindow(),element); //$NON-NLS-1$
					}
				} 
				catch (Exception exc) 
				{
					exc.printStackTrace();
				}
			}

			return page;
	}
	
	/**
	 * method which resets the contents of the Recorder Control View
	 */
	public void reset()
	{
		statusList.removeAll();
		kBytesReceived.setText(""); //$NON-NLS-1$
	}
	
	/**
	 * returns the default instance of the recorder Control View.  Also changes the current perspective to the Test Perspective and creates
	 * the recorder control view if it has not previously been created.  
	 * @return RecorderControlView
	 */
	public static RecorderControlView getInstance()
	{
				
		if(instance == null)
		{
			
			IWorkbenchWindow window = getActiveWorkbenchWindow();
		
			try
			{
				IWorkbenchPage persp = getActivePage();     
				instance = (RecorderControlView)persp.showView(ID);
//			
//					if(view != null){
////						 ...do something		 
//					}			 					 
			}
			catch(Exception e)
			{
				String msg = RecorderPlugin.getResourceString("RecorderControlView.UNABLE_TO_CREATE_RECORDER_CONTROL_VIEW_ERROR_MSG");                  //$NON-NLS-1$

				Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), null ); 

				ErrorDialog.openError(window.getShell(),
						msg,
						"", // no special message //$NON-NLS-1$
						err);

				e.printStackTrace();    
			}                               
			
		}
		return instance;
	}
	
		

	/**
	 * adds a message to the status box
	 * @param String message
	 * void
	 */
	public void addMessage(final String message)
	{
		Display.getDefault().asyncExec
		(
			new Runnable()
			{				
				public void run()
				{
					statusList.add(message);
					statusList.setSelection(statusList.getItems().length-1);
				}
			}
		
		);		
	}
	
	
	/**
	 * sets the number in the kByes received control
	 * @param int receivedKBytes
	 */
	public void setKBytesReceived(final int receivedKBytes)
	{
		Display.getDefault().asyncExec
		(
			new Runnable()
			{				
				public void run()
				{
					kBytesReceived.setText(String.valueOf(receivedKBytes));
				}
			}
	
		);
	
	}

	

	/**
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus()
	{

	}

	/**
	 * @see org.eclipse.ui.IWorkbenchPart#dispose()
	 */
	public void dispose()
	{
		super.dispose();
		instance=null;
	}

}
