/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration;

import org.eclipse.emf.common.util.EList;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>CFG Deployment Spec</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeploymentLocation <em>Deployment Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getExecutionLocation <em>Execution Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getConcurrencyMode <em>Concurrency Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getArtifact <em>Artifact</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeployment <em>Deployment</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGDeploymentSpec()
 * @model 
 * @generated
 */
public interface CFGDeploymentSpec extends CMNNamedElement{
	/**
	 * Returns the value of the '<em><b>Deployment Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Deployment Location</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Deployment Location</em>' attribute.
	 * @see #setDeploymentLocation(String)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGDeploymentSpec_DeploymentLocation()
	 * @model 
	 * @generated
	 */
	String getDeploymentLocation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeploymentLocation <em>Deployment Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Deployment Location</em>' attribute.
	 * @see #getDeploymentLocation()
	 * @generated
	 */
	void setDeploymentLocation(String value);

	/**
	 * Returns the value of the '<em><b>Execution Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Execution Location</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Execution Location</em>' attribute.
	 * @see #setExecutionLocation(String)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGDeploymentSpec_ExecutionLocation()
	 * @model 
	 * @generated
	 */
	String getExecutionLocation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getExecutionLocation <em>Execution Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Execution Location</em>' attribute.
	 * @see #getExecutionLocation()
	 * @generated
	 */
	void setExecutionLocation(String value);

	/**
	 * Returns the value of the '<em><b>Concurrency Mode</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.common.configuration.CFGConcurrency}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Concurrency Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Concurrency Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.common.configuration.CFGConcurrency
	 * @see #setConcurrencyMode(CFGConcurrency)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGDeploymentSpec_ConcurrencyMode()
	 * @model 
	 * @generated
	 */
	CFGConcurrency getConcurrencyMode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getConcurrencyMode <em>Concurrency Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Concurrency Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.common.configuration.CFGConcurrency
	 * @see #getConcurrencyMode()
	 * @generated
	 */
	void setConcurrencyMode(CFGConcurrency value);

	/**
	 * Returns the value of the '<em><b>Artifact</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGArtifact#getDeploymentSpec <em>Deployment Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Artifact</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Artifact</em>' reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGDeploymentSpec_Artifact()
	 * @see org.eclipse.hyades.models.common.configuration.CFGArtifact#getDeploymentSpec
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGArtifact" opposite="deploymentSpec"
	 * @generated
	 */
	EList getArtifact();

	/**
	 * Returns the value of the '<em><b>Deployment</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getDeploymentSpecs <em>Deployment Specs</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Deployment</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Deployment</em>' container reference.
	 * @see #setDeployment(TPFDeployment)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGDeploymentSpec_Deployment()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFDeployment#getDeploymentSpecs
	 * @model opposite="deploymentSpecs" required="true"
	 * @generated
	 */
	TPFDeployment getDeployment();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeployment <em>Deployment</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Deployment</em>' container reference.
	 * @see #getDeployment()
	 * @generated
	 */
	void setDeployment(TPFDeployment value);

} // CFGDeploymentSpec
