/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;

import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Variable</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getRole <em>Role</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getDatapool <em>Datapool</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLVariableImpl extends CMNNamedElementImpl implements DPLVariable {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRole() <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRole()
	 * @generated
	 * @ordered
	 */
	protected static final DPLRole ROLE_EDEFAULT = DPLRole.UNSPECIFIED_DATA_LITERAL;

	/**
	 * The cached value of the '{@link #getRole() <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRole()
	 * @generated
	 * @ordered
	 */
	protected DPLRole role = ROLE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLVariableImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_DatapoolPackage.eINSTANCE.getDPLVariable();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType()
	{
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType)
	{
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLRole getRole()
	{
		return role;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRole(DPLRole newRole)
	{
		DPLRole oldRole = role;
		role = newRole == null ? ROLE_EDEFAULT : newRole;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__ROLE, oldRole, role));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapool getDatapool()
	{
		if (eContainerFeatureID != Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL) return null;
		return (DPLDatapool)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatapool(DPLDatapool newDatapool)
	{
		if (newDatapool != eContainer || (eContainerFeatureID != Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL && newDatapool != null)) {
			if (EcoreUtil.isAncestor(this, newDatapool))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDatapool != null)
				msgs = ((InternalEObject)newDatapool).eInverseAdd(this, Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES, DPLDatapool.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newDatapool, Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL, newDatapool, newDatapool));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
					return eBasicSetContainer(null, Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_DatapoolPackage.DPL_DATAPOOL__VARIABLES, DPLDatapool.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_VARIABLE__ID:
				return getId();
			case Common_DatapoolPackage.DPL_VARIABLE__NAME:
				return getName();
			case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
				return getDescription();
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				return getType();
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				return getRole();
			case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
				return getDatapool();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_VARIABLE__ID:
				setId((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__NAME:
				setName((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				setType((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				setRole((DPLRole)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
				setDatapool((DPLDatapool)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_VARIABLE__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				setRole(ROLE_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
				setDatapool((DPLDatapool)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_VARIABLE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_DatapoolPackage.DPL_VARIABLE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_DatapoolPackage.DPL_VARIABLE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				return role != ROLE_EDEFAULT;
			case Common_DatapoolPackage.DPL_VARIABLE__DATAPOOL:
				return getDatapool() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", role: ");
		result.append(role);
		result.append(')');
		return result.toString();
	}

} //DPLVariableImpl
