/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Execution Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getOwnerId <em>Owner Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getText <em>Text</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getExecutionHistory <em>Execution History</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getInteractionFragment <em>Interaction Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFExecutionEventImpl extends EObjectImpl implements TPFExecutionEvent
{
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected static final String OWNER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected String ownerId = OWNER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final long TIMESTAMP_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected long timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInteractionFragment() <em>Interaction Fragment</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragment()
	 * @generated
	 * @ordered
	 */
	protected BVRInteractionFragment interactionFragment = null;

	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList children = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected TPFExecutionEventImpl()
	{
		super();
		id = new Guid().toString();
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId()
	{
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId)
	{
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOwnerId()
	{
		return ownerId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerId(String newOwnerId)
	{
		String oldOwnerId = ownerId;
		ownerId = newOwnerId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID, oldOwnerId, ownerId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTimestamp()
	{
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(long newTimestamp)
	{
		long oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText()
	{
		return text;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setText(String newText)
	{
		String oldText = text;
		text = newText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT, oldText, text));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionHistory getExecutionHistory()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY) return null;
		return (TPFExecutionHistory)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutionHistory(TPFExecutionHistory newExecutionHistory)
	{
		if (newExecutionHistory != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY && newExecutionHistory != null)) {
			if (EcoreUtil.isAncestor(this, newExecutionHistory))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newExecutionHistory != null)
				msgs = ((InternalEObject)newExecutionHistory).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newExecutionHistory, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, newExecutionHistory, newExecutionHistory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionFragment getInteractionFragment()
	{
		if (interactionFragment != null && interactionFragment.eIsProxy()) {
			BVRInteractionFragment oldInteractionFragment = interactionFragment;
			interactionFragment = (BVRInteractionFragment)EcoreUtil.resolve(interactionFragment, this);
			if (interactionFragment != oldInteractionFragment) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT, oldInteractionFragment, interactionFragment));
			}
		}
		return interactionFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionFragment basicGetInteractionFragment()
	{
		return interactionFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteractionFragment(BVRInteractionFragment newInteractionFragment)
	{
		BVRInteractionFragment oldInteractionFragment = interactionFragment;
		interactionFragment = newInteractionFragment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT, oldInteractionFragment, interactionFragment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getChildren()
	{
		if (children == null) {
			children = new EObjectContainmentWithInverseEList(TPFExecutionEvent.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT);
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionEvent getParent()
	{
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT) return null;
		return (TPFExecutionEvent)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(TPFExecutionEvent newParent)
	{
		if (newParent != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newParent, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
					return ((InternalEList)getChildren()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
					return ((InternalEList)getChildren()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
	{
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				return getId();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				return getOwnerId();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				return new Long(getTimestamp());
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				return getText();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				if (resolve) return getInteractionFragment();
				return basicGetInteractionFragment();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return getChildren();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return getParent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				setOwnerId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				setTimestamp(((Long)newValue).longValue());
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				setText((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				setParent((TPFExecutionEvent)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				setOwnerId(OWNER_ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				setText(TEXT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				getChildren().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				setParent((TPFExecutionEvent)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				return OWNER_ID_EDEFAULT == null ? ownerId != null : !OWNER_ID_EDEFAULT.equals(ownerId);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				return timestamp != TIMESTAMP_EDEFAULT;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				return interactionFragment != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return children != null && !children.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return getParent() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", ownerId: ");
		result.append(ownerId);
		result.append(", timestamp: ");
		result.append(timestamp);
		result.append(", text: ");
		result.append(text);
		result.append(')');
		return result.toString();
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}
} //TPFExecutionEventImpl
