/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.configuration;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.configuration.ConfigurationType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ConfigurationTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConfigurationTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDescriptionPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONFIG_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONFIG_DESCR", "_UI_ConfigurationType_type"),
				 ConfigurationPackage.eINSTANCE.getConfigurationType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONFIG_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONFIG_ID", "_UI_ConfigurationType_type"),
				 ConfigurationPackage.eINSTANCE.getConfigurationType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getConfigurationType_ContextInstance());
		}
		return childrenReferences;
	}


	/**
	 * This returns ConfigurationType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_CONFIGURATION);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((ConfigurationType)object).getDescription();
		return label == null || label.length() == 0 ?
			getString("_UI_ConfigurationType_type") :
			getString("_UI_ConfigurationType_type") + " " + label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(ConfigurationType.class)) {
			case ConfigurationPackage.CONFIGURATION_TYPE__DESCRIPTION:
			case ConfigurationPackage.CONFIGURATION_TYPE__UNIQUE_ID:
			case ConfigurationPackage.CONFIGURATION_TYPE__CONTEXT_INSTANCE: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

        ContextInstanceType context = ConfigurationFactory.eINSTANCE.createContextInstanceType();
        context.setContinuousOperation(true);
        context.setContinuousOperation(false);
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getConfigurationType_ContextInstance(),
				 context));
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
