/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.configuration;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.*;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.*;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.*;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.*;
import org.eclipse.hyades.logging.adapter.model.internal.parser.*;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.model.internal.unit.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.configuration.ContextInstanceType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ContextInstanceTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
		
	public final static String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_DESCR");
	public final static String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_ID");
	public final static String MAXIMUM_IDLE = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_TIME");
	public final static String PAUSE_INTERVAL = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_PAUSEI");
	public final static String CONTINUOUS_OP = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_CONT");

	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextInstanceTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addContinuousOperationPropertyDescriptor(object);
			addDescriptionPropertyDescriptor(object);
			addMaximumIdleTimePropertyDescriptor(object);
			addPauseIntervalPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Continuous Operation feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addContinuousOperationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_CONT"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_CONT", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_ContinuousOperation(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_DESCR", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Maximum Idle Time feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addMaximumIdleTimePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_TIME"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_TIME", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_MaximumIdleTime(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Pause Interval feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addPauseIntervalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_PAUSEI"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_PAUSEI", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_PauseInterval(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_ID", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} 
	 * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
	 * support in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenReferences(Object object) {
		if (childrenReferences == null) {
			super.getChildrenReferences(object);
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Parser());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit());
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter());			
			childrenReferences.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter());
		}
		return childrenReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EReference getChildReference(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildReference(object, child);
	}


	/**
	 * This returns ContextInstanceType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		
		if(object instanceof SensorConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_SENSOR);
		else if(object instanceof ExtractorType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_EXTRACTOR);	   
		else if(object instanceof FormatterType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_FORMATTER);
		else if(object instanceof ProcessUnitType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PROCESS_UNIT);
		else if(object instanceof OutputterConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_OUTPUTTER);
		else if(object instanceof ParserConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PARSER);
		   		   
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_CONTEXT_INSTANCE);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		ContextInstanceType contextInstanceType = (ContextInstanceType)object;
		
		String label = contextInstanceType.getUniqueID();
		return label == null || label.length() == 0 ?
			"Context Instance" :
			"Context Instance [" + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(ContextInstanceType.class)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:			
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		SensorConfigType sensor = SensorFactory.eINSTANCE.createSensorConfigType();
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor(),
				 sensor));

		Extractor extractor = ExtractorFactory.eINSTANCE.createExtractor();
		extractor.setContainsLineBreaks(true);
		extractor.setContainsLineBreaks(false);
		extractor.setIncludeEndPattern(true);
		extractor.setIncludeEndPattern(false);
		extractor.setIncludeStartPattern(true);
		extractor.setIncludeStartPattern(false);
		extractor.setReplaceLineBreaks(true);
		extractor.setReplaceLineBreaks(false);		 
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor(),
				 extractor));

        ParserConfigType parser = ParserFactory.eINSTANCE.createParserConfigType();
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Parser(),
				 parser));

		ProcessUnit unit = UnitFactory.eINSTANCE.createProcessUnit();
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit(),
				 unit));

		FormatterType formatter = FormatterFactory.eINSTANCE.createFormatterType();
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter(),
				 formatter));

		OutputterConfigType outputter = OutputterFactory.eINSTANCE.createOutputterConfigType();
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter(),
				 outputter));
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
	
}
