/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.extractor;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.*;
import org.eclipse.hyades.logging.adapter.ui.*;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.extractor.ExtractorType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ExtractorTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_EXTR_DESCR");
	public static final String HAS_START_PATTERN = AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_STARTP");	
	public static final String START_PATTERN = AcadEditorPlugin.getPlugin().getString("STR_EXTR_STARTP");
	public static final String HAS_END_PATTERN = AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_ENDP");		
	public static final String END_PATTERN = AcadEditorPlugin.getPlugin().getString("STR_EXTR_END_PATTERN");
	public static final String CONTAINS_LINE_BREAKS = AcadEditorPlugin.getPlugin().getString("STR_EXTR_HAS_LINEB");
	public static final String LINE_BREAK_SYMBOL = AcadEditorPlugin.getPlugin().getString("STR_EXTR_LINE_BSYMB");	
	public static final String REPLACE_LINE_BREAKS = AcadEditorPlugin.getPlugin().getString("REPLACE_LINE_BREAK");
			
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtractorTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addContainsLineBreaksPropertyDescriptor(object);
			addDescriptionPropertyDescriptor(object);
			addEndPatternPropertyDescriptor(object);
			addIncludeEndPatternPropertyDescriptor(object);
			addIncludeStartPatternPropertyDescriptor(object);
			addLineBreakSymbolPropertyDescriptor(object);
			addReplaceLineBreaksPropertyDescriptor(object);
			addStartPatternPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Contains Line Breaks feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addContainsLineBreaksPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_HAS_LINEB"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_HAS_LINEB", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_ContainsLineBreaks(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_DESCR", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the End Pattern feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addEndPatternPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_END_PATTERN"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_END_PATTERN", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_EndPattern(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Include End Pattern feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIncludeEndPatternPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_INC_ENDP"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_INC_ENDP", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_IncludeEndPattern(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Include Start Pattern feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIncludeStartPatternPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_INC_STARTP"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_INC_STARTP", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_IncludeStartPattern(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Line Break Symbol feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLineBreakSymbolPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_LINE_BSYMB"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_LINE_BSYMB", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_LineBreakSymbol(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Replace Line Breaks feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addReplaceLineBreaksPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("REPLACE_LINE_BREAK"),
				 getString("_UI_PropertyDescriptor_description", "REPLACE_LINE_BREAK", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_ReplaceLineBreaks(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Start Pattern feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addStartPatternPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_STARTP"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_STARTP", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_StartPattern(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_EXTR_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_EXTR_ID", "_UI_ExtractorType_type"),
				 ExtractorPackage.eINSTANCE.getExtractorType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}


	/**
	 * This returns ExtractorType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_EXTRACTOR);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((ExtractorType)object).getUniqueID();
		return label == null || label.length() == 0 ?
			"Extractor" :
			"Extractor ["  + label + "]";
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(ExtractorType.class)) {
			case ExtractorPackage.EXTRACTOR_TYPE__CONTAINS_LINE_BREAKS:
			case ExtractorPackage.EXTRACTOR_TYPE__DESCRIPTION:
			case ExtractorPackage.EXTRACTOR_TYPE__END_PATTERN:
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_END_PATTERN:
			case ExtractorPackage.EXTRACTOR_TYPE__INCLUDE_START_PATTERN:
			case ExtractorPackage.EXTRACTOR_TYPE__LINE_BREAK_SYMBOL:
			case ExtractorPackage.EXTRACTOR_TYPE__REPLACE_LINE_BREAKS:
			case ExtractorPackage.EXTRACTOR_TYPE__START_PATTERN:
			case ExtractorPackage.EXTRACTOR_TYPE__UNIQUE_ID: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}	
}
