/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.sensor;


import java.util.*;

import org.eclipse.emf.common.notify.*;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.ui.*;


/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.acad.model.internal.sensor.SingleFileSensorType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SingleFileSensorTypeItemProvider
	extends SensorBaseTypeItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String DIRECTORY = AcadEditorPlugin.getPlugin().getString("STR_SINGLE_FILES_DIR");
	public static final String FILE_NAME = AcadEditorPlugin.getPlugin().getString("STR_SINGLE_FILES_FILE");
	public static final String CONVERTER = AcadEditorPlugin.getPlugin().getString("STR_SINGLEFS_CONVERTER");	
	public static final String SHELL = AcadEditorPlugin.getPlugin().getString("STR_SINGLEFS_SHELL");	
	
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileSensorTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addConverterPropertyDescriptor(object);
			addShellPropertyDescriptor(object);
			addDirectoryPropertyDescriptor(object);
			addFileNamePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Converter feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addConverterPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_SINGLEFS_CONVERTER"),
				 getString("_UI_PropertyDescriptor_description", "STR_SINGLEFS_CONVERTER", "_UI_SingleFileSensorType_type"),
				 SensorPackage.eINSTANCE.getSingleFileSensorType_Converter(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}
	
	/**
	 * This adds a property descriptor for the Shell feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addShellPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
		(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
						getString("STR_SINGLEFS_SHELL"),
						getString("_UI_PropertyDescriptor_description", "STR_SINGLEFS_SHELL", "_UI_SingleFileSensorType_type"),
						SensorPackage.eINSTANCE.getSingleFileSensorType_Shell(),
						true,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}
	

	/**
	 * This adds a property descriptor for the Directory feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDirectoryPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_SINGLE_FILES_DIR"),
				 getString("_UI_PropertyDescriptor_description", "STR_SINGLE_FILES_DIR", "_UI_SingleFileSensorType_type"),
				 SensorPackage.eINSTANCE.getSingleFileSensorType_Directory(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the File Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addFileNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_SINGLE_FILES_FILE"),
				 getString("_UI_PropertyDescriptor_description", "STR_SINGLE_FILES_FILE", "_UI_SingleFileSensorType_type"),
				 SensorPackage.eINSTANCE.getSingleFileSensorType_FileName(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}


	/**
	 * This returns SingleFileSensorType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_STREAM);		
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((SingleFileSensorType)object).getFileName();
		return label == null || label.length() == 0 ?
			getString("_UI_SingleFileSensorType_type") :
			getString("_UI_SingleFileSensorType_type") + " " + label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(SingleFileSensorType.class)) {
			case SensorPackage.SINGLE_FILE_SENSOR_TYPE__CONVERTER:
			case SensorPackage.SINGLE_FILE_SENSOR_TYPE__SHELL:
			case SensorPackage.SINGLE_FILE_SENSOR_TYPE__DIRECTORY:
			case SensorPackage.SINGLE_FILE_SENSOR_TYPE__FILE_NAME: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}	
}
