/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.outputter.*;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class LoggingOutputterSection extends Composite
								implements IDetails, ModifyListener
										   , INotifyChangedListener
{
	protected Text agentName;			
	protected Text logTime;
    protected boolean isDisplaying;
    protected LoggingAgentOutputterType currentSelection;
    protected LoggingAgentOutputterTypeItemProvider itemProvider;
    protected OutputterItemProviderAdapterFactory itemFactory;
	
	
	public LoggingOutputterSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new OutputterItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_LOG_AGENT_ANAME"), SWT.NONE);	
		agentName = factory.createText(this, "", SWT.MULTI);
		agentName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_LOG_AGENT_WAIT"), SWT.NONE);	
		logTime = factory.createText(this, "", SWT.NULL);
		logTime.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		agentName.addModifyListener(this);
		logTime.addModifyListener(this);
		
		itemProvider = (LoggingAgentOutputterTypeItemProvider)itemFactory.createLoggingAgentOutputterTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
 
		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)((LoggingAgentOutputterType)object).eContainer().eContainer());

		if(currentSelection == object)
		  return;
        
		if(agentName.isFocusControl() || logTime.isFocusControl())		   
		  return;
        
		currentSelection = (LoggingAgentOutputterType)object;
		isDisplaying = true;
			
		agentName.setText(currentSelection.getAgentName()==null?"":currentSelection.getAgentName());
		logTime.setText(currentSelection.getWaitUntilLoggingTime()==null?"":currentSelection.getWaitUntilLoggingTime());

		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (LoggingAgentOutputterType)currentSelection;
		
		this.currentSelection.setAgentName(agentName.getText());
		this.currentSelection.setWaitUntilLoggingTime(logTime.getText());
		
		return false;

	}
	
	public void setFocusToText(){
	        agentName.setFocus();
	        agentName.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == agentName)
		{
			String text = agentName.getText();
			if(!text.equals(currentSelection.getAgentName()))
			{
				if(text.length() == 0 && currentSelection.getAgentName() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						LoggingAgentOutputterTypeItemProvider.AGENT_NAME);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == logTime)
		{
			String text = logTime.getText();
			if(!text.equals(currentSelection.getWaitUntilLoggingTime()))
			{
				if(text.length() == 0 && currentSelection.getWaitUntilLoggingTime() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						LoggingAgentOutputterTypeItemProvider.LOG_TIME);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

}
