/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.*;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.parser.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class RuleAttributeSection extends Composite
								implements IDetails, SelectionListener
										   , INotifyChangedListener
{
	protected Label nameText;			
	protected Label uniqueId;
	protected Button usePreviuos;
	
	protected Label indexText;			
    protected boolean isDisplaying;
    protected RuleAttributeType currentSelection;
    protected RuleAttributeTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory;
	
	
	public RuleAttributeSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new ParserItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
				
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME"), SWT.NONE);	
		nameText = factory.createLabel(this, "");
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "unspecified");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ATTR_INDEX"), SWT.NONE);	
		indexText = factory.createLabel(this, "");
		indexText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		usePreviuos = factory.createButton(this, AcadEditorPlugin.getDefault().getString("STR_USE_PREV_ATTR"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;		
		usePreviuos.setLayoutData(data);	
		
		itemProvider = (RuleAttributeTypeItemProvider)itemFactory.createRuleAttributeAdapter();
		itemProvider.addListener(this);
		
		usePreviuos.addSelectionListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
   
		if(currentSelection == object)
		  return;

		currentSelection = (RuleAttributeType)object;
		isDisplaying = true;
			
		nameText.setText(currentSelection.getName()==null?"":currentSelection.getName());
		uniqueId.setText(currentSelection.getId()==null?"unspecified":currentSelection.getId());
		indexText.setText(currentSelection.getIndex()==null?"":currentSelection.getIndex());
		usePreviuos.setSelection(currentSelection.isUsePreviousMatchSubstitutionAsDefault());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {
		
		this.currentSelection = (RuleAttributeType)currentSelection;    
		
	    this.currentSelection.setUsePreviousMatchSubstitutionAsDefault(usePreviuos.getSelection());
		
		return false;

	}
	
	public void setFocusToText(){
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetSelected(SelectionEvent e)
	{
		IItemPropertyDescriptor descriptor = 
			itemProvider.getPropertyDescriptor(
				currentSelection,
				RuleAttributeItemProvider.NAME);
		
		currentSelection.setUsePreviousMatchSubstitutionAsDefault(usePreviuos.getSelection());		
		String oldValue = currentSelection.getName();		
		if(descriptor != null)
		{
			descriptor.setPropertyValue(currentSelection, oldValue);										
		}	
	}
	
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}	

}
