/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.io.File;
import java.net.*;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;
import org.eclipse.hyades.logging.adapter.ui.*;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.util.AcadPerspective;
import org.eclipse.jface.action.*;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;


/**
 */
public class ResultView extends ViewPart 
{
	private final String RESULT_TITLE = AcadEditorPlugin.getPlugin().getString("RESULT_VIEW");

	TextViewer resultViewer;	
		
	/**
	 * Constructor
	 */
	public ResultView() {
		super();
		
	}

	/**
	 * @see IViewPart.init(IViewSite)
	 */
	public void init(IViewSite site) throws PartInitException {
		super.init(site);
	}

	/**
	 * Initializes this view with the given view site.  A memento is passed to
 	 * the view which contains a snapshot of the views state from a previous
	 * session.  	
	 */
	public void init(IViewSite site,IMemento memento) throws PartInitException {
		init(site);
		
		enableEditActions();
		
	}
	
	/**
	 * @see IWorkbenchPart#createPartControl(Composite)
	 */
	public void createPartControl(Composite parent) {
		
		resultViewer = new TextViewer(parent, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.WRAP);
		resultViewer.setEditable(false);
		
		// Create menu and toolbars.
		createActions();
		createMenu();
		createToolbar();
		createContextMenu();

		set_Title();	
		
		WorkbenchHelp.setHelp(parent, ContextIds.ACAD_EDITOR_RESULT_VIEW);
			
	}
	
	/**
	 * @see WorkbenchPart#setFocus()
	 */
	public void setFocus() {
		if(resultViewer != null && resultViewer.getControl().isDisposed())
			resultViewer.getControl().setFocus();
	}

	/**
	 * Create the actions.
	 */
	public void createActions() {
		
	}

	/**
	 * Returns the image descriptor with the given relative path.
	 */
	
	private ImageDescriptor getImageDescriptor(String relativePath) {
		
		
		String iconPath = "icons/full/elcl16/";
		try {
			
			URL installURL = AcadEditorPlugin.getPlugin().getBaseURL();
			URL url = new URL(installURL, iconPath + relativePath);
			
			return ImageDescriptor.createFromURL(url);
			
			
		}
		catch (MalformedURLException e) {
			// should not happen
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	
	
	/**
	 * Create menu.
	 */
	private void createMenu() {
		IMenuManager mgr = getViewSite().getActionBars().getMenuManager();
	}
	
	/**
	 * Create toolbar.
	 */
	private void createToolbar() {
		IToolBarManager mgr = getViewSite().getActionBars().getToolBarManager();
	}
		
	/**
	 * Create context menu.
	 */
	private void createContextMenu() {
		// Create menu manager.
		MenuManager menuMgr = new MenuManager();
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager mgr) {
				fillContextMenu(mgr);
			}
		});
		
		// Create menu.
		Menu menu = menuMgr.createContextMenu(resultViewer.getControl());
		resultViewer.getControl().setMenu(menu);
		
		// Register menu for extension.
		getSite().registerContextMenu(menuMgr, resultViewer);
	}

	/**
	 * Hook global actions
	 */
	private void hookGlobalActions() {
		IActionBars bars = getViewSite().getActionBars();
	}
		
	private void fillContextMenu(IMenuManager mgr) {

	}

	private void updateActionEnablement() {
	}
					
	public void set_Title()
	{
		AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
		
		StringBuffer title = (new StringBuffer(RESULT_TITLE)).append(" ");
		
		if(model != null)
		{
			long currentEvent = model.getCurrentCount();
			if(currentEvent >=0 ) 
			  currentEvent++;
			else 
			  currentEvent = 0;  
			
			if(model.getContextInstance() == null || model.getContextInstance().eContainer() == null)
			{  
				title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
			}
			else
			{
				SensorConfigType sensor = AcadGuiModelManager.getLogForConfiguration(model);
				if(sensor != null)
				{  
					SensorType type = sensor.getType();
				
					switch(type.getValue())
					{
						case SensorType.ADAPTER_CBE_SENSOR:
						  title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
						  break;
						case SensorType.SINGLE_FILE_SENSOR:
						  SingleFileSensorType fileSensor = sensor.getSingleFileSensor();
						  if(fileSensor == null)
							title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
						  else
							title.append(fileSensor.getDirectory()).append(File.separator)
								  .append(fileSensor.getFileName());	
						  break;
					}
					title.append(" ").append(AcadEditorPlugin.getPlugin().getString("STR_RESULT_TITLE", new Object[] {String.valueOf(currentEvent)}));
				
				}
				else
				{
					title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
				}
				
			}
				 				 			
		}
		
		super.setTitle(title.toString());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#dispose()
	 */
	public void dispose() 
	{
		// Auto-generated method stub
		super.dispose();
	}
	
	public String getText()
	{
		return ((StyledText)resultViewer.getControl()).getText();
	}
	/**
	 * 
	 * @return
	 */
	public static final ResultView getResultView(boolean show)
	{
		try {
			IWorkbenchPage page = AcadEditorPlugin.getDefault().getActivePage();
			if(page == null)
			  return null;
			
			IViewPart view =
				page.findView(AcadPerspective.ID_RESULTVIEW);
				
			if (view != null && view instanceof ResultView)
			{
				return (ResultView) view;	
				
			}
			
			if(show)
			{
				view = page.showView(AcadPerspective.ID_RESULTVIEW);
	
				if (view != null && view instanceof ResultView)
				{
					return (ResultView) view;	
	
				}
				
			}
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
			return null;
		}
		
		return null;
	}

    public void reset()
    {
     	setResult("");
    }
    
    public void setResult(String text)
    {
    	if(resultViewer != null && text != null)
			resultViewer.setDocument(new Document(text));
    }
    
	public void enableActions()
	{
	}


	protected void enableEditActions()
	{
		ActionHandlerListener.DEFAULT.connectPart(this);
	}

}
